package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class UnpackCommand {
    public UnpackCommand(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        LiteralArgumentBuilder<class_2168> tbCommand = class_2170.method_9247("tb").requires(player -> player.method_9259(2));

        tbCommand.then(class_2170.method_9247("unpack")
                .then(class_2170.method_9244("pos", class_2262.method_9698())
                        .executes(source -> unpackTargetBlockEntity(source.getSource(), class_2262.method_9696(source, "pos"))))
                .then(class_2170.method_9244("target", class_2186.method_9308())
                        .executes(source -> unpackTargetInventory(source.getSource(), class_2186.method_9315(source, "target")))));

        dispatcher.register(tbCommand);
    }

    public int unpackTargetBlockEntity(class_2168 source, class_2338 blockPos) {
        if(source.method_9225().method_8321(blockPos) instanceof BackpackBlockEntity blockEntity) {
            class_2371<class_1799> stacks = collectItems(blockEntity.getWrapper());
            if(!stacks.isEmpty()) {
                if(!source.method_9225().field_9236) {
                    class_1264.method_17349(source.method_9225(), blockPos, stacks);
                }
                source.method_9226(() -> class_2561.method_43470("Dropping contents of backpack placed at " + blockPos.method_23854()), true);
                return 1;
            } else {
                source.method_9213(class_2561.method_43470("There's no contents in backpack at coordinates " + blockPos.method_23854()));
                return -1;
            }
        } else {
            source.method_9213(class_2561.method_43470("There's no backpack at coordinates " + blockPos.method_23854()));
            return -1;
        }
    }

    public int unpackTargetInventory(class_2168 source, class_3222 serverPlayer) {
        boolean hasBackpack = ComponentUtils.isWearingBackpack(serverPlayer);
        if(TravelersBackpack.enableIntegration()) return -1;

        if(hasBackpack) {
            AtomicBoolean flag = new AtomicBoolean(false);
            ComponentUtils.getComponent(serverPlayer).ifPresent(data -> {
                class_2371<class_1799> stacks = collectItems(data.getWrapper());
                if(!stacks.isEmpty()) {
                    if(!source.method_9225().field_9236) {
                        data.synchronise();
                        class_1264.method_17349(source.method_9225(), serverPlayer.method_24515(), stacks);
                        flag.set(true);
                    }
                }
            });
            if(flag.get()) {
                source.method_9226(() -> class_2561.method_43470("Dropping contents of " + serverPlayer.method_5476().getString() + " backpack at " + serverPlayer.method_24515().method_23854()), true);
                return 1;
            } else {
                source.method_9213(class_2561.method_43470("There's no contents in " + serverPlayer.method_5476().getString() + " backpack"));
                return -1;
            }
        } else {
            source.method_9213(class_2561.method_43470("Player " + serverPlayer.method_5476().getString() + " is not wearing backpack"));
            return -1;
        }
    }

    public class_2371<class_1799> collectItems(BackpackWrapper wrapper) {
        class_2371<class_1799> stacks = class_2371.method_10211();
        stacks.addAll(collectItems(wrapper.getStorage()));
        stacks.addAll(collectItems(wrapper.getTools()));
        stacks.addAll(collectItems(wrapper.getUpgrades()));
        return stacks;
    }

    public class_2371<class_1799> collectItems(ItemStackHandler handler) {
        class_2371<class_1799> stacks = class_2371.method_10211();
        for(int i = 0; i < handler.getSlots(); i++) {
            class_1799 stackInSlot = handler.getStackInSlot(i);
            if(!stackInSlot.method_7960()) {
                stacks.add(stackInSlot);
                handler.setStackInSlot(i, class_1799.field_8037);
            }
        }
        return stacks;
    }
}