package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.Cooldown;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.CooldownHelper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;

public class BackpackAbilities {
    /**
     * Main class for all available abilities
     * connects to few events and block methods to execute/remove proper abilities
     * It's such a mess right now, I might create better system for all of that in the future.
     * <p>
     * //Connecting abilities to player, abilities removals
     * {@link NeoForgeEventHandler#playerTick(PlayerTickEvent.Post)}
     * <p>
     * //Connecting abilities to block entity
     * {@link BackpackBlockEntity#tick(class_1937, class_2338, class_2680, BackpackBlockEntity)}
     * <p>
     * //Ability removals
     * {@link ServerActions#switchAbilitySlider(BackpackWrapper, boolean)} (Player, boolean)}
     * <p>
     * //Cosmetic only
     * {@link TravelersBackpackBlock#method_9496(class_2680, class_1937, class_2338, class_5819)}
     * <p>
     * //Few uses of block abilities
     * {@link TravelersBackpackBlock}
     * <p>
     * //Creeper ability
     * {@link NeoForgeEventHandler#playerDeath(LivingDeathEvent)}
     */
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();

    /**
     * Return TRUE to enable ability cooldown decreasing
     */
    public boolean abilityTick(@Nullable class_1799 backpack, @Nullable class_1657 player) {
        boolean tickCooldown = false;
        if(backpack != null) {
            class_1792 backpackItem = backpack.method_7909();

            //Check if backpack has cooldown set in config
            boolean effectHasCooldown = false;

            //Has effect associated
            if(getBackpackEffects().containsKey(backpack.method_7909())) {
                //Check if there's backpack entry in cooldowns config
                if(getCooldowns().containsKey(backpack.method_7909())) {
                    effectHasCooldown = true;
                }
                //If not, then add timed mob effect and re-apply them, without any cooldown ticking
                if(!effectHasCooldown) {
                    Collection<BackpackEffect> backpackEffects = getBackpackEffects().get(backpackItem);
                    for(BackpackEffect backpackEffect : backpackEffects) {

                        //Squid Backpack Exception - Night Vision only works underwater
                        if(backpack.method_7909() == ModItems.SQUID_TRAVELERS_BACKPACK.method_8389() && backpackEffect.effect() == class_1294.field_5925) {
                            if(!player.method_5799()) {
                                continue;
                            }
                        }

                        addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                    }
                } else { //If yes, then check if there's active cooldown
                    //If no active cooldown
                    if(!hasCooldown(backpack)) {
                        //Apply effects
                        Collection<BackpackEffect> backpackEffects = getBackpackEffects().get(backpackItem);
                        for(BackpackEffect backpackEffect : backpackEffects) {
                            addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                        }
                        //Apply cooldown
                        setCooldown(ComponentUtils.getBackpackWrapperArtificial(player), backpackItem);
                    }
                    //Tick cooldown, but return at the end to check if there's any custom ability associated with backpack
                    tickCooldown = true;
                }
            }

            if(backpackItem == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23724, NETHERITE_ARMOR_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23724, DIAMOND_ARMOR_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.GOLD_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23724, GOLD_ARMOR_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.EMERALD_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23726, LUCK_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.IRON_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23724, IRON_ARMOR_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_47758, ENDERMAN_REACH_DISTANCE_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23716, WARDEN_MAX_HEALTH_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.FOX_TRAVELERS_BACKPACK) {
                attributeAbility(player, false, class_5134.field_23719, FOX_MOVEMENT_SPEED_MODIFIER);
                return false;
            }

            if(backpackItem == ModItems.CAKE_TRAVELERS_BACKPACK) {
                cakeAbility(backpack, player);
                return true;
            }

            if(backpackItem == ModItems.CACTUS_TRAVELERS_BACKPACK) {
                cactusAbilityEquipped(player, backpack);
                return false;
            }

            if(backpackItem == ModItems.CHICKEN_TRAVELERS_BACKPACK) {
                chickenAbility(backpack, player, false);
                return true;
            }

            if(backpackItem == ModItems.CREEPER_TRAVELERS_BACKPACK) {
                return true;
            }

            if(backpackItem == ModItems.BLAZE_TRAVELERS_BACKPACK) {
                blazeAbility(player);
                return false;
            }

            if(backpackItem == ModItems.SPIDER_TRAVELERS_BACKPACK) {
                spiderAbility(player);
                return false;
            }

            if(backpackItem == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                ocelotAbility(player);
                return false;
            }

            if(backpackItem == ModItems.COW_TRAVELERS_BACKPACK) {
                cowAbility(backpack, player);
                return true;
            }

            if(backpackItem == ModItems.WITHER_TRAVELERS_BACKPACK) {
                witherAbilityTick(player);
                return false;
            }
        }
        return tickCooldown;
    }

    public boolean abilityTickBlock(@Nullable BackpackBlockEntity blockEntity) {
        if(blockEntity.getWrapper() != null) {
            class_1792 backpackItem = blockEntity.getWrapper().getBackpackStack().method_7909();
            if(backpackItem == ModItems.CACTUS_TRAVELERS_BACKPACK) {
                cactusAbilityBlockEntity(blockEntity.getWrapper(), blockEntity);
                return false;
            }
        }
        return false;
    }

    public void abilityRemoval(@Nullable class_1799 stack, @Nullable class_1657 player) {
        if(stack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23724, NETHERITE_ARMOR_MODIFIER);
        }

        if(stack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23724, DIAMOND_ARMOR_MODIFIER);
        }

        if(stack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23724, IRON_ARMOR_MODIFIER);
        }

        if(stack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23724, GOLD_ARMOR_MODIFIER);
        }

        if(stack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_47758, ENDERMAN_REACH_DISTANCE_MODIFIER);
        }

        if(stack.method_7909() == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23716, WARDEN_MAX_HEALTH_MODIFIER);
        }

        if(stack.method_7909() == ModItems.FOX_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23719, FOX_MOVEMENT_SPEED_MODIFIER);
        }

        if(stack.method_7909() == ModItems.EMERALD_TRAVELERS_BACKPACK) {
            attributeAbility(player, true, class_5134.field_23726, LUCK_MODIFIER);
        }
    }

    /**
     * Called in TravelersBackpackBlock#animateTick method to enable visual only abilities for BackpackBlockEntity
     */

    public void animateTick(BackpackBlockEntity backpackBlockEntity, class_2680 stateIn, class_1937 level, class_2338 pos, class_5819 rand) {
        if(backpackBlockEntity.getWrapper() != null && backpackBlockEntity.getWrapper().isAbilityEnabled()) {
            class_2248 block = stateIn.method_26204();
            if(block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK) {
                bookshelfAbility(null, backpackBlockEntity);
            }

            if(block == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                spongeAbility(backpackBlockEntity);
            }
        }
    }

    public final class_1322 NETHERITE_ARMOR_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "netherite_backpack_armor"), 4.0D, class_1322.class_1323.field_6328);
    public final class_1322 DIAMOND_ARMOR_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "diamond_backpack_armor"), 3.0D, class_1322.class_1323.field_6328);
    public final class_1322 IRON_ARMOR_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "iron_backpack_armor"), 2.0D, class_1322.class_1323.field_6328);
    public final class_1322 GOLD_ARMOR_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "gold_backpack_armor"), 2.0D, class_1322.class_1323.field_6328);
    public final class_1322 ENDERMAN_REACH_DISTANCE_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "enderman_backpack_reach"), 1.0D, class_1322.class_1323.field_6328);
    public final class_1322 WARDEN_MAX_HEALTH_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "warden_backpack_max_health"), 4.0D, class_1322.class_1323.field_6328);
    public final class_1322 FOX_MOVEMENT_SPEED_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "fox_movement_speed"), 0.1D, class_1322.class_1323.field_6331);
    public final class_1322 LUCK_MODIFIER = new class_1322(class_2960.method_60655(TravelersBackpack.MODID, "emerald_backpack_luck"), 1.0D, class_1322.class_1323.field_6328);

    public Multimap<class_6880<class_1320>, class_1322> getAttributeAbilityMultimap(class_1799 backpack) {
        Multimap<class_6880<class_1320>, class_1322> multimap = ArrayListMultimap.create();
        if(backpack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23724, NETHERITE_ARMOR_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23724, DIAMOND_ARMOR_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23724, GOLD_ARMOR_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23724, IRON_ARMOR_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_47758, ENDERMAN_REACH_DISTANCE_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23716, WARDEN_MAX_HEALTH_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.FOX_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23719, FOX_MOVEMENT_SPEED_MODIFIER);
            return multimap;
        }
        if(backpack.method_7909() == ModItems.EMERALD_TRAVELERS_BACKPACK) {
            multimap.put(class_5134.field_23726, LUCK_MODIFIER);
            return multimap;
        }
        return multimap;
    }

    public void attributeAbility(class_1657 player, boolean isRemoval, class_6880<class_1320> attribute, class_1322 modifier) {
        class_1324 armor = player.method_5996(attribute);
        if(isRemoval && armor != null && armor.method_6196(modifier.comp_2447())) {
            armor.method_6200(modifier.comp_2447());
        }
        if(!isRemoval && armor != null && !armor.method_6196(modifier.comp_2447())) {
            armor.method_26837(modifier);
        }
    }

    public void armorAbilityRemovals(class_1657 player) {
        attributeAbility(player, true, class_5134.field_23724, NETHERITE_ARMOR_MODIFIER);
        attributeAbility(player, true, class_5134.field_23724, DIAMOND_ARMOR_MODIFIER);
        attributeAbility(player, true, class_5134.field_23724, IRON_ARMOR_MODIFIER);
        attributeAbility(player, true, class_5134.field_23724, GOLD_ARMOR_MODIFIER);

        attributeAbility(player, true, class_5134.field_47758, ENDERMAN_REACH_DISTANCE_MODIFIER);
        attributeAbility(player, true, class_5134.field_23716, WARDEN_MAX_HEALTH_MODIFIER);
        attributeAbility(player, true, class_5134.field_23719, FOX_MOVEMENT_SPEED_MODIFIER);
        attributeAbility(player, true, class_5134.field_23726, LUCK_MODIFIER);
    }

    public int lapisAbility(class_1657 player) {
        if(ABILITIES.checkBackpack(player, ModItems.LAPIS_TRAVELERS_BACKPACK)) {
            float random = player.method_59922().method_43057();
            if(random <= 0.15F) {
                if(random <= 0.025F) {
                    sendParticlesPacket(class_2398.field_28479, player, 2);
                }
                return 2;
            }
        }
        return 1;
    }

    public void bookshelfAbility(@Nullable class_1657 player, @Nullable BackpackBlockEntity backpackBlockEntity) {
        class_2338 enchanting = BackpackDeathHelper.findBlock3D(backpackBlockEntity.method_10997(), backpackBlockEntity.method_11016().method_10263(), backpackBlockEntity.method_11016().method_10264(), backpackBlockEntity.method_11016().method_10260(), class_2246.field_10485, 2, 2);
        if(enchanting != null) {
            if(!backpackBlockEntity.method_10997().method_22347(new class_2338((enchanting.method_10263() - backpackBlockEntity.method_11016().method_10263()) / 2 + backpackBlockEntity.method_11016().method_10263(), enchanting.method_10264(), (enchanting.method_10260() - backpackBlockEntity.method_11016().method_10260()) / 2 + backpackBlockEntity.method_11016().method_10260()))) {
                return;
            }
            for(int o = 0; o < 4; o++) {
                backpackBlockEntity.method_10997().method_8406(class_2398.field_11215, enchanting.method_10263() + 0.5D, enchanting.method_10264() + 2.0D, enchanting.method_10260() + 0.5D,
                        ((backpackBlockEntity.method_11016().method_10263() - enchanting.method_10263()) + backpackBlockEntity.method_10997().field_9229.method_43057()) - 0.5D,
                        ((backpackBlockEntity.method_11016().method_10264() - enchanting.method_10264()) - backpackBlockEntity.method_10997().field_9229.method_43057() - 1.0F),
                        ((backpackBlockEntity.method_11016().method_10260() - enchanting.method_10260()) + backpackBlockEntity.method_10997().field_9229.method_43057()) - 0.5D);
            }
        }
    }

    public void spongeAbility(BackpackBlockEntity backpackBlockEntity) {
        if(backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
            TanksUpgrade tanksUpgrade = backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
            if(!tanksUpgrade.getLeftTank().isEmpty() && !tanksUpgrade.getRightTank().isEmpty()) {
                if(tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910) && tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780(class_3612.field_15910)) {
                    if(tanksUpgrade.getLeftTank().getFluidAmount() == tanksUpgrade.getLeftTank().getCapacity() && tanksUpgrade.getRightTank().getFluidAmount() == tanksUpgrade.getRightTank().getCapacity()) {
                        float f = backpackBlockEntity.method_10997().field_9229.method_43057() * (float)Math.PI * 2.0F;
                        float f1 = backpackBlockEntity.method_10997().field_9229.method_43057() * 0.5F + 0.5F;
                        float f2 = class_3532.method_15374(f) * 0.5F * f1;
                        float f3 = class_3532.method_15362(f) * 0.5F * f1;
                        backpackBlockEntity.method_10997().method_8406(class_2398.field_11202,
                                backpackBlockEntity.method_11016().method_10263() + f2 + 0.5F,
                                backpackBlockEntity.method_11016().method_10264() + backpackBlockEntity.method_10997().field_9229.method_43057(),
                                backpackBlockEntity.method_11016().method_10260() + f3 + 0.5F, (double)(float)Math.pow(2.0D, (backpackBlockEntity.method_10997().field_9229.method_43048(169) - 12) / 12.0D) / 24.0D, -1.0D, 0.0D);
                    }
                }
            }
        }
    }

    //Restores Hunger and grants Regeneration I for 10 seconds
    public void cakeAbility(class_1799 backpack, class_1657 player) {
        if(!hasCooldown(backpack)) {
            player.method_7344().method_7585(20, 0.1F);
            player.method_6092(new class_1293(class_1294.field_5924, 10 * 20));
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_20614, class_3419.field_15256, 0.6F, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.3F + 1.0F);

            if(player.method_37908() instanceof class_3218 server) {
                for(int i = 0; i < 3; i++) {
                    float f = server.field_9229.method_43057() * (float)Math.PI * 2.0F;
                    float f1 = server.field_9229.method_43057() * 0.5F + 0.5F;
                    float f2 = class_3532.method_15374(f) * 0.5F * f1;
                    float f3 = class_3532.method_15362(f) * 0.5F * f1;
                    server.method_14199(class_2398.field_11201,
                            player.method_19538().field_1352 + f2,
                            player.method_5829().field_1322 + player.method_37908().field_9229.method_43057() + 0.5F,
                            player.method_19538().field_1350 + f3, 3, (double)(float)Math.pow(2.0D, (player.method_37908().field_9229.method_43048(169) - 12) / 12.0D) / 24.0D, -1.0D, 0.0D, 0);
                }
            }
            if(getCooldowns().containsKey(backpack.method_7909())) {
                Cooldown config = getCooldowns().get(backpack.method_7909());
                backpack.method_57379(ModDataComponents.COOLDOWN, CooldownHelper.createCooldown(config.minCooldown(), config.maxCooldown()));
            }
        }
    }

    public void chickenAbility(class_1799 backpack, class_1657 player, boolean firstSwitch) {
        if(firstSwitch && !player.method_37908().field_9236) {
            if(!hasCooldown(backpack)) {
                BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
                setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
                return;
            }
        }
        if(!hasCooldown(backpack)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15219, class_3419.field_15256, 1.0F, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.3F + 1.0F);
            player.method_5706(class_1802.field_8803);
            if(player.method_37908().field_9236) return;
            setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
        }
    }

    public void cactusAbilityEquipped(@Nullable class_1657 player, @Nullable class_1799 backpack) {
        int gameTime = (int)player.method_37908().method_8510();
        BackpackWrapper wrapper;
        int cooldown = backpack.method_57825(ModDataComponents.COOLDOWN, 0);
        if(cooldown >= 1000) {
            wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY);
            if(wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidVariantWrapper water = new FluidVariantWrapper(FluidVariant.of(class_3612.field_15910), FluidConstants.BUCKET);
                if(!player.method_37908().field_9236) {
                    leftTank.fill(water, true);
                    rightTank.fill(water, true);
                }

                if(player.method_37908().field_9236) return;

                wrapper.setCooldown(0);
            } else {
                return;
            }
        }

        int drops = 0;
        if(gameTime % 100 == 0) {
            wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            if(player.method_5799()) {
                drops += 5 * 10;
            }

            if(isUnderRain(player.method_24515(), player.method_37908())) {
                drops += 5 * 10;
            }

            int getCurrentDrops = wrapper.getCooldown();
            if(drops > 0) {
                if(player.method_37908().field_9236) return;

                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public void cactusAbilityBlockEntity(@Nullable BackpackWrapper wrapper, @Nullable BackpackBlockEntity blockEntity) {
        int cooldown = wrapper.getCooldown();
        if(cooldown >= 1000) {
            if(wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidVariantWrapper water = new FluidVariantWrapper(FluidVariant.of(class_3612.field_15910), FluidConstants.BUCKET);
                leftTank.fill(water, true);
                rightTank.fill(water, true);
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }

        int drops = 0;
        int gameTime = (int)blockEntity.method_10997().method_8510();

        if(gameTime % 100 == 0) {
            if(isUnderRain(blockEntity.method_11016(), blockEntity.method_10997())) {
                drops += 5 * 10;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if(drops > 0) {
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public static void melonAbility(BackpackBlockEntity backpackBlockEntity) {
        if(backpackBlockEntity.getWrapper().isAbilityEnabled() && backpackBlockEntity.getWrapper().getCooldown() <= 0) {
            class_2248.method_9577(backpackBlockEntity.method_10997(), backpackBlockEntity.method_11016(), new class_1799(class_1802.field_8497, backpackBlockEntity.method_10997().field_9229.method_43051(0, 3)));
            setCooldown(backpackBlockEntity.getWrapper(), backpackBlockEntity.getWrapper().getBackpackStack().method_7909());
        }
    }

    public static void pumpkinAbility(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        boolean flag = BackpackAbilities.ABILITIES.checkBackpack(player, ModItems.PUMPKIN_TRAVELERS_BACKPACK);
        if(flag) {
            cir.setReturnValue(false);
        }
    }

    public static boolean creeperAbility(class_1657 player) {
        BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
        if(player.method_29504() && wrapper != null && wrapper.getBackpackStack().method_7909() == ModItems.CREEPER_TRAVELERS_BACKPACK && wrapper.isAbilityEnabled() && wrapper.getCooldown() <= 0) {
            player.method_6033(1.0F);
            player.method_6012();
            player.method_6092(new class_1293(class_1294.field_5924, 450, 1));
            player.method_6092(new class_1293(class_1294.field_5898, 100, 1));
            player.method_6092(new class_1293(class_1294.field_5918, 400, 0));
            player.method_37908().method_55117(player, player.method_48923().method_48802(player), null, player.method_23322(0.5F), player.method_23318(), player.method_23325(0.5F), 3.0F, false, class_1937.class_7867.field_40888);
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15057, class_3419.field_15256, 1.2F, 0.5F);

            if(!player.method_37908().field_9236) {
                setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
            }
            return true;
        }
        return false;
    }

    public void blazeAbility(class_1657 player) {
        if(player.field_6017 >= 3.0F) {
            for(int i = 0; i < 4; ++i) {
                player.method_37908().method_8406(class_2398.field_11237, player.method_23322(0.5D), player.method_23319(), player.method_23325(0.5D), 0.0D, 0.0D, 0.0D);
            }
            player.field_6017 = 0.0F;
        }
    }

    public static void blazeAbility(class_3966 result, class_1677 fireball, CallbackInfo ci) {
        if(result.method_17782() instanceof class_1657 player && ABILITIES.checkBackpack(player, ModItems.BLAZE_TRAVELERS_BACKPACK)) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0F, 0.8F + player.method_37908().field_9229.method_43057() * 0.4F);
            sendParticlesPacket(class_2398.field_11240, player, 3);

            fireball.method_31472();
            ci.cancel();
        }
    }

    public static void ghastAbility(class_1571 ghast, class_1309 livingEntity, CallbackInfo ci) {
        if(livingEntity instanceof class_1657 player) {
            if(ABILITIES.checkBackpack(player, ModItems.GHAST_TRAVELERS_BACKPACK)) {
                if(ghast.method_49107() != player) {
                    ci.cancel();
                }
            }
        }
    }

    public void spiderAbility(class_1657 player) {
        if(player.field_5976 && !player.method_52535()) {
            //Make player climb the wall if crashed with elytra
            if(player.method_6128()) {
                player.method_23670();
            }

            if(!player.method_24828() && player.method_18276()) {
                player.method_18800(player.method_18798().field_1352, 0.0D, player.method_18798().field_1350);
            } else {
                player.method_18800(player.method_18798().field_1352, 0.20D, player.method_18798().field_1350);
                class_1937 level = player.method_37908();
                class_2680 state = level.method_8320(player.method_24515().method_10093(player.method_5735()));
                player.method_37908().method_8406(new class_2388(class_2398.field_11217, state),
                        player.method_23317() + (level.field_9229.method_43058() - 0.5D) * (double)player.method_18377(class_4050.field_18076).comp_2185(),
                        player.method_23318() + 0.1D,
                        player.method_23321() + (level.field_9229.method_43058() - 0.5D) * (double)player.method_18377(class_4050.field_18076).comp_2185(),
                        0.0D, 1.5D, 0.0D);
            }
        }
    }

    public static void witherAbilityTick(class_1657 player) {
        if(ABILITIES.checkBackpack(player, ModItems.WITHER_TRAVELERS_BACKPACK)) {
            if(player.method_6059(class_1294.field_5920)) {
                player.method_6016(class_1294.field_5920);
            }
        }
    }

    public static void witherAbility(class_1657 player, class_1297 target) {
        if(ABILITIES.checkBackpack(player, ModItems.WITHER_TRAVELERS_BACKPACK)) {
            if(target instanceof class_1309 living) {
                living.method_6092(new class_1293(class_1294.field_5920, 3 * 20, 1));
            }
        }
    }

    public static void wardenAbility(class_1657 player, class_1297 target) {
        if(ABILITIES.checkBackpack(player, ModItems.WARDEN_TRAVELERS_BACKPACK)) {
            if(target instanceof class_1309 living) {
                living.method_6092(new class_1293(class_1294.field_5909, 2 * 20, 1));
            }
        }
    }

    public static void beeAbility(class_1657 player, class_1297 target) {
        if(ABILITIES.checkBackpack(player, ModItems.BEE_TRAVELERS_BACKPACK)) {
            class_1282 damageSource = player.method_48923().method_48801(player);
            boolean flag = target.method_5643(damageSource, 1.0F);

            if(flag) {
                if(player.method_37908() instanceof class_3218 serverLevel) {
                    class_1890.method_60107(serverLevel, target, damageSource);
                }

                if(target instanceof class_1309 living) {
                    living.method_21755(living.method_21753() + 1);
                    living.method_37222(new class_1293(class_1294.field_5899, 4 * 20, 0), player);
                }
            }
        }
    }

    private final class_4051 ocelotAbilityTargeting = class_4051.method_36625().method_18418(64.0D);

    public void ocelotAbility(class_1657 player) {
        if(player.method_37908().method_21726(class_1588.class, ocelotAbilityTargeting, player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1009(6.0D, 2.0D, 6.0D)) != null) {
            addTimedMobEffect(player, class_1294.field_5904, 20, 30, 0, false, false, false);
        }
    }

    public void cowAbility(class_1799 stack, class_1657 player) {
        if(!player.method_6026().isEmpty() && !hasCooldown(stack)) {
            if(player.method_6026().stream().anyMatch(effect -> effect.method_5579().comp_349().method_18792() == class_4081.field_18272)) {
                BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
                if(!player.method_37908().field_9236) {
                    player.method_37908().method_20290(2007, player.method_24515(), 16777215);
                    setCooldown(wrapper, stack.method_7909());
                }
                player.method_37908().method_8396(null, player.method_24515(), class_3417.field_29543, class_3419.field_15248, 1.0F, player.method_59922().method_43057() * 0.1F + 0.9F);
                removeAllNegativeEffects(player.method_37908(), player);
            }
        }
    }

    public boolean removeAllNegativeEffects(class_1937 level, class_1657 player) {
        if(level.field_9236) {
            return false;
        } else if(player.method_6026().isEmpty()) {
            return false;
        } else {
            Collection<class_1293> negativeEffects = player.method_6026().stream().filter(effect -> effect.method_5579().comp_349().method_18792() == class_4081.field_18272).toList();
            for(class_1293 instance : negativeEffects) {
                player.method_6016(instance.method_5579());
            }
            return true;
        }
    }

    //Utility methods

    private boolean isUnderRain(class_2338 pos, class_1937 level) {
        return level.method_8311(pos) && level.method_8419();
    }

    public static boolean isAbilityEnabledInConfig(class_1799 stack) {
        if(!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.ALLOWED_ABILITIES.contains(stack.method_7909())) {
            return false;
        }
        return true;
    }

    public boolean checkBackpack(class_1657 player, class_1792 item) {
        if(!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.ALLOWED_ABILITIES.contains(item)) {
            return false;
        }
        return ComponentUtils.isWearingBackpack(player) && ComponentUtils.getWearingBackpack(player).method_7909() == item && ComponentUtils.getWearingBackpack(player).method_57825(ModDataComponents.ABILITY_ENABLED, true);
    }

    public void addTimedMobEffect(class_1657 player, class_6880<class_1291> effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if(!player.method_6059(effect)) {
            player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if(player.method_6059(effect)) {
            if(player.method_6112(effect) != null && player.method_6112(effect).method_5584() <= minDuration) {
                player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
            }
        }
    }

    public static void sendParticlesPacket(class_2394 type, class_1657 player, int count) {
        for(int i = 0; i < count; i++) {
            double d0 = player.method_37908().field_9229.method_43059() * 0.02D;
            double d1 = player.method_37908().field_9229.method_43059() * 0.02D;
            double d2 = player.method_37908().field_9229.method_43059() * 0.02D;
            if(player.method_37908() instanceof class_3218 server) {
                server.method_14199(type, player.method_23322(1.0D), player.method_23319() + 0.5D, player.method_23325(1.0D), 1, d0, d1, d2, 0.0F);
            }
        }
    }

    public static boolean isOnList(List<class_1792> list, class_1799 stackToCheck) {
        return list.stream().anyMatch(s -> s == stackToCheck.method_7909());
    }

    public static boolean hasCooldown(class_1799 stack) {
        return stack.method_57825(ModDataComponents.COOLDOWN, 0) > 0;
    }

    public static void setCooldown(BackpackWrapper wrapper, class_1792 item) {
        if(getCooldowns().containsKey(item)) {
            Cooldown cooldown = getCooldowns().get(item);
            wrapper.setCooldown(CooldownHelper.createCooldown(cooldown.minCooldown(), cooldown.maxCooldown()));
        }
    }

    public static List<class_1792> getAllowedAbilities() {
        return ALLOWED_ABILITIES;
    }

    public static Map<class_1792, Cooldown> getCooldowns() {
        return COOLDOWNS;
    }

    public static Multimap<class_1792, BackpackEffect> getBackpackEffects() {
        return BACKPACK_EFFECTS;
    }

    public static final List<class_1792> ALLOWED_ABILITIES = new ArrayList<>();
    public static final Multimap<class_1792, BackpackEffect> BACKPACK_EFFECTS = ArrayListMultimap.create();
    public static final Map<class_1792, Cooldown> COOLDOWNS = new HashMap<>();

    //All equipped backpack abilities
    public static List<class_1792> ITEM_ABILITIES_LIST = new ArrayList<>(List.of(
            ModItems.NETHERITE_TRAVELERS_BACKPACK,
            ModItems.DIAMOND_TRAVELERS_BACKPACK,
            ModItems.GOLD_TRAVELERS_BACKPACK,
            ModItems.EMERALD_TRAVELERS_BACKPACK,
            ModItems.IRON_TRAVELERS_BACKPACK,
            ModItems.LAPIS_TRAVELERS_BACKPACK,

            ModItems.QUARTZ_TRAVELERS_BACKPACK,
            ModItems.CAKE_TRAVELERS_BACKPACK,

            ModItems.CACTUS_TRAVELERS_BACKPACK,
            ModItems.HAY_TRAVELERS_BACKPACK,
            ModItems.PUMPKIN_TRAVELERS_BACKPACK,

            ModItems.CREEPER_TRAVELERS_BACKPACK,
            ModItems.DRAGON_TRAVELERS_BACKPACK,
            ModItems.ENDERMAN_TRAVELERS_BACKPACK,
            ModItems.BLAZE_TRAVELERS_BACKPACK,
            ModItems.GHAST_TRAVELERS_BACKPACK,
            ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK,
            ModItems.SPIDER_TRAVELERS_BACKPACK,
            ModItems.WITHER_TRAVELERS_BACKPACK,
            ModItems.WARDEN_TRAVELERS_BACKPACK,

            ModItems.BAT_TRAVELERS_BACKPACK,
            ModItems.BEE_TRAVELERS_BACKPACK,
            ModItems.OCELOT_TRAVELERS_BACKPACK,
            ModItems.COW_TRAVELERS_BACKPACK,
            ModItems.CHICKEN_TRAVELERS_BACKPACK,
            ModItems.SQUID_TRAVELERS_BACKPACK,
            ModItems.FOX_TRAVELERS_BACKPACK
    ));

    //Removals for attribute modifier abilities
    public static List<class_1792> ITEM_ABILITIES_REMOVAL_LIST = new ArrayList<>(List.of(
            ModItems.NETHERITE_TRAVELERS_BACKPACK,
            ModItems.DIAMOND_TRAVELERS_BACKPACK,
            ModItems.GOLD_TRAVELERS_BACKPACK,
            ModItems.IRON_TRAVELERS_BACKPACK,
            ModItems.EMERALD_TRAVELERS_BACKPACK,

            ModItems.ENDERMAN_TRAVELERS_BACKPACK,
            ModItems.WARDEN_TRAVELERS_BACKPACK,
            ModItems.FOX_TRAVELERS_BACKPACK
    ));

    //All block backpack abilities
    public static List<class_1792> BLOCK_ABILITIES_LIST = new ArrayList<>(List.of(
            ModItems.REDSTONE_TRAVELERS_BACKPACK,

            ModItems.BOOKSHELF_TRAVELERS_BACKPACK,
            ModItems.SPONGE_TRAVELERS_BACKPACK,

            ModItems.CACTUS_TRAVELERS_BACKPACK,
            ModItems.MELON_TRAVELERS_BACKPACK
    ));

    //All equipped backpack abilities
    public static List<class_1792> CUSTOM_DESCRIPTIONS = new ArrayList<>(List.of(
            ModItems.LAPIS_TRAVELERS_BACKPACK,
            ModItems.REDSTONE_TRAVELERS_BACKPACK,

            ModItems.BOOKSHELF_TRAVELERS_BACKPACK,
            ModItems.SPONGE_TRAVELERS_BACKPACK,

            ModItems.CAKE_TRAVELERS_BACKPACK,

            ModItems.CACTUS_TRAVELERS_BACKPACK,
            ModItems.HAY_TRAVELERS_BACKPACK,
            ModItems.PUMPKIN_TRAVELERS_BACKPACK,
            ModItems.MELON_TRAVELERS_BACKPACK,

            ModItems.CREEPER_TRAVELERS_BACKPACK,
            ModItems.ENDERMAN_TRAVELERS_BACKPACK,
            ModItems.BLAZE_TRAVELERS_BACKPACK,
            ModItems.GHAST_TRAVELERS_BACKPACK,
            ModItems.SPIDER_TRAVELERS_BACKPACK,
            ModItems.WITHER_TRAVELERS_BACKPACK,
            ModItems.WARDEN_TRAVELERS_BACKPACK,

            ModItems.BEE_TRAVELERS_BACKPACK,
            ModItems.OCELOT_TRAVELERS_BACKPACK,
            ModItems.COW_TRAVELERS_BACKPACK,
            ModItems.CHICKEN_TRAVELERS_BACKPACK
    ));
}