package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.*;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.item.HoseItem;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9331;
import java.util.List;
import java.util.Optional;

public class ServerActions {
    public static void swapTool(class_1657 player, double scrollDelta) {
        if(ComponentUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.TOOLS_ONLY);
            ItemStackHandler inv = wrapper.getTools();
            if(InventoryHelper.isEmpty(inv)) return;

            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;

            for(int i = 0; i <= lastSlot; i++) {
                if(!inv.getStackInSlot(i).method_7960()) {
                    j++;
                }
            }

            class_1799[] tools = new class_1799[j];
            int slot = 0;

            for(int i = 0; i <= j - 1; i++) {
                tools[slot] = inv.getStackInSlot(i).method_7972();
                slot++;
            }

            swapTool(scrollDelta, tools, player);
            slot = 0;

            for(int i = 0; i <= j - 1; i++) {
                inv.setStackInSlot(i, tools[slot]);
                slot++;
            }

            if(player instanceof class_3222 serverPlayer) {
                ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, ActionTypeTrigger.SWAP_TOOLS);
            }
            wrapper.sendDataToClients(ModDataComponents.TOOLS_CONTAINER);
        }
    }

    public static void swapTool(double delta, class_1799[] tools, class_1657 player) {
        if(delta > 0) {
            class_1799 tempStack = tools[0];

            for(int i = 0; i <= tools.length - 1; i++) {
                if(i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                } else {
                    tools[i] = tools[i + 1];
                }
            }
        }
        if(delta < 0) {
            class_1799 tempStack = tools[tools.length - 1];

            for(int i = tools.length - 1; i >= 0; i--) {
                if(i - 1 < 0) {
                    tools[0] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                } else {
                    tools[i] = tools[i - 1];
                }
            }
        }
    }

    public static void equipBackpack(class_1657 player, boolean equip) {
        if(equip) {
            handleEquipBackpack(player);
        } else {
            handleUnequipBackpack(player);
        }
    }

    public static boolean swapBackpack(class_1657 player) {
        class_1937 level = player.method_37908();

        if(level.field_9236 || !ComponentUtils.isWearingBackpack(player)) {
            return false;
        }

        if(player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }

        class_1799 equippedBackpack = ComponentUtils.getWearingBackpack(player).method_7972();
        class_1799 newBackpack = player.method_6047().method_7972();

        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(newBackpack);
            attachment.synchronise();
        });

        runAbilitiesRemoval(player);

        player.method_6047().method_7934(1);
        player.method_31548().method_7394(equippedBackpack);

        return true;
    }

    public static void runAbilitiesRemoval(class_1657 player) {
        BackpackAbilities.ABILITIES.armorAbilityRemovals(player);
    }

    public static boolean equipBackpack(class_1657 player) {
        class_1937 level = player.method_37908();

        if(level.field_9236) {
            return false;
        }

        if(ComponentUtils.isWearingBackpack(player)) {
            return swapBackpack(player);
        }

        if(player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }

        class_1799 stack = player.method_6047().method_7972();

        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(stack);
            attachment.synchronise();
        });

        player.method_6047().method_7934(1);
        return true;
    }

    public static void handleEquipBackpack(class_1657 player) {
        if(!equipBackpack(player))
            return;

        playEquippingSound(player);
    }

    public static boolean unequipBackpack(class_1657 player) {
        class_1937 level = player.method_37908();

        if(level.field_9236 || !ComponentUtils.isWearingBackpack(player)) {
            return false;
        }

        if(player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }

        class_1799 backpack = ComponentUtils.getWearingBackpack(player).method_7972();

        //Try to add to inventory
        int index = player.method_31548().method_7390(backpack);
        if(index == -1) {
            index = player.method_31548().method_7376();
        }

        if(index != -1) {
            player.method_31548().method_7398(backpack);
        } else {
            if(player instanceof class_3222 serverPlayer) {
                serverPlayer.method_43496(class_2561.method_43471(Reference.NO_SPACE));
            }
            return false;
        }

        /*if(!player.getInventory().add(backpack)) {
            if(player instanceof ServerPlayer serverPlayer) {
                serverPlayer.sendSystemMessage(Component.translatable(Reference.NO_SPACE));
            }
            return false;
        }*/

        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(new class_1799(class_1802.field_8162, 0));
            attachment.synchronise();
        });

        return true;
    }

    public static void handleUnequipBackpack(class_1657 player) {
        if(!unequipBackpack(player))
            return;

        playEquippingSound(player);
    }

    private static void playEquippingSound(class_1657 player) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.05F, (1.0F + (player.method_37908().method_8409().method_43057() - player.method_37908().method_8409().method_43057()) * 0.2F) * 0.7F);
    }

    /*public static void equipBackpack(Player player, boolean equip) {
        if(equip) {
            equipBackpack(player);
        } else {
            unequipBackpack(player);
        }
    }

    public static void equipBackpack(Player player) {
        Level level = player.level();

        if(!level.isClientSide) {
            if(!ComponentUtils.isWearingBackpack(player)) {
                if(player.containerMenu instanceof BackpackItemMenu) ((ServerPlayer)player).closeContainer();

                ItemStack stack = player.getMainHandItem().copy();

                ComponentUtils.getComponent(player).ifPresent(attachment -> {
                    attachment.equipBackpack(stack);
                    attachment.synchronise();
                });

                player.getMainHandItem().shrink(1);
                level.playSound(null, player.blockPosition(), SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0F, (1.0F + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2F) * 0.7F);

            } else {
                ((ServerPlayer)player).closeContainer();
                player.sendSystemMessage(Component.translatable(Reference.OTHER_BACKPACK));
            }
        }
    }

    public static void unequipBackpack(Player player) {
        Level level = player.level();

        if(!level.isClientSide) {
            if(ComponentUtils.isWearingBackpack(player)) {
                if(player.containerMenu instanceof BackpackItemMenu) ((ServerPlayer)player).closeContainer();

                ItemStack backpack = ComponentUtils.getWearingBackpack(player).copy();

                if(!player.getInventory().add(backpack)) {
                    player.sendSystemMessage(Component.translatable(Reference.NO_SPACE));
                    return;
                }

                ComponentUtils.getComponent(player).ifPresent(attachment -> {
                    attachment.equipBackpack(new ItemStack(Items.AIR, 0));
                    attachment.synchronise();
                });
                level.playSound(null, player.blockPosition(), SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.05F, (1.0F + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2F) * 0.7F);
            }
        }
    }*/

    public static void openBackpackFromSlot(class_3222 player, int index, boolean fromSlot) {
        if(index >= 0 && index < player.method_31548().field_7547.size()) {
            class_1799 backpackStack = player.method_31548().field_7547.get(index);
            if(backpackStack.method_7909() instanceof TravelersBackpackItem) {
                if(!TravelersBackpackConfig.getConfig().backpackSettings.allowOnlyEquippedBackpack) {
                    if(!fromSlot || TravelersBackpackConfig.getConfig().backpackSettings.allowOpeningFromSlot) {
                        BackpackContainer.openBackpack(player, backpackStack, Reference.ITEM_SCREEN_ID, index);
                    }
                }
            }
        }
    }

    public static void openBackpackSettings(class_3222 player, int entityId, boolean open) {
        if(player.method_5628() == entityId) {
            if(player.field_7512 instanceof BackpackBaseMenu menu) {
                if(open) {
                    if(menu.getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
                        if(player.method_37908().method_8321(menu.getWrapper().getBackpackPos()) instanceof BackpackBlockEntity backpackBlockEntity) {
                            backpackBlockEntity.openSettings(player, backpackBlockEntity, menu.getWrapper().getBackpackPos());
                        }
                    } else {
                        BackpackSettingsContainer.openSettings(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                    }
                }
            } else if(player.field_7512 instanceof BackpackSettingsMenu menu) {
                if(!open) {
                    if(menu.getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
                        if(player.method_37908().method_8321(menu.getWrapper().getBackpackPos()) instanceof BackpackBlockEntity backpackBlockEntity) {
                            backpackBlockEntity.openBackpack(player, backpackBlockEntity, menu.getWrapper().getBackpackPos());
                        }
                    } else {
                        BackpackContainer.openBackpack(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                    }
                }
            }
        }
    }

    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public static void modifyUpgradeTab(class_3222 player, int slot, boolean open, int packetType) {
        if(player instanceof class_3222 serverPlayer && serverPlayer.field_7512 instanceof BackpackBaseMenu menu) {
            class_1799 upgradeStack = menu.getWrapper().getUpgrades().getStackInSlot(slot);
            if(!upgradeStack.method_7960()) {
                class_1799 updateStack = upgradeStack.method_7972();
                updateStack.method_57379(getPacketType(packetType), open);
                menu.getWrapper().getUpgrades().setStackInSlot(slot, updateStack);

                if(packetType == UPGRADE_ENABLED) {
                    if(menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(slot)) {
                        menu.getWrapper().getUpgradeManager().mappedUpgrades.get(slot).ifPresent(upgradeBase -> {
                            if(upgradeBase instanceof IEnable upg) {
                                upg.setEnabled(open);
                            }
                        });
                    }
                }
            }
        }
    }

    public static class_9331 getPacketType(int type) {
        return switch(type) {
            case 0 -> ModDataComponents.TAB_OPEN;
            case 1 -> ModDataComponents.UPGRADE_ENABLED;
            case 2 -> ModDataComponents.SHIFT_CLICK_TO_BACKPACK;
            case 3 -> ModDataComponents.IS_PLAYING;
            default -> ModDataComponents.TAB_OPEN;
        };
    }

    public static void removeBackpackUpgrade(class_3222 player, int slot) {
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            BackpackWrapper wrapper = menu.getWrapper();
            if(!wrapper.getUpgrades().getStackInSlot(slot).method_7960()) {
                Optional<UpgradeBase<?>> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(slot);

                class_1799 upgradeStack = wrapper.getUpgrades().getStackInSlot(slot).method_7972();
                upgradeStack.method_57379(ModDataComponents.TAB_OPEN, false);
                wrapper.getUpgrades().setStackInSlot(slot, class_1799.field_8037);

                upgrade.ifPresent(upgradeBase -> upgradeBase.onUpgradeRemoved(upgradeStack, player));

                if(!player.method_31548().method_7394(upgradeStack)) {
                    player.method_7328(upgradeStack, true);
                }
                wrapper.saveHandler.run();
            }
        }
    }

    public static void switchAbilitySlider(class_3222 player, boolean sliderValue) {
        BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);

        //If ability slider is being switched in the backpack screen, then reassign the wrapper
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            wrapper = menu.getWrapper();
        }

        wrapper.setDataAndSync(ModDataComponents.ABILITY_ENABLED, sliderValue);

        //Run for equipped backpack
        if(wrapper.getBackpackOwner() != null) {
            if(BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }

            if(wrapper.getBackpackStack().method_7909() == ModItems.CHICKEN_TRAVELERS_BACKPACK && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbility(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void showToolSlots(class_3222 player, boolean show) {
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            menu.getWrapper().setDataAndSync(ModDataComponents.SHOW_TOOL_SLOTS, show);
        }
    }

    public static void sortBackpack(class_3222 player, int button, boolean shiftPressed) {
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            ContainerSorter.selectSort(menu.getWrapper(), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(class_1657 player) {
        if(player.field_7512 instanceof BackpackSettingsMenu menu) {
            boolean visibility = menu.getWrapper().getBackpackStack().method_57825(ModDataComponents.IS_VISIBLE, true);
            menu.getWrapper().setDataAndSync(ModDataComponents.IS_VISIBLE, !visibility);
        }
    }

    public static void toggleButtonsVisibility(class_1657 player) {
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            boolean current = menu.getWrapper().showMoreButtons();
            menu.getWrapper().setDataAndSync(ModDataComponents.SHOW_MORE_BUTTONS, !current);
        }
    }

    public static void toggleSleepingBag(class_1657 player, class_2338 pos, boolean isEquipped) {
        class_1937 level = player.method_37908();
        if(isEquipped) {
            class_2338 sleepingBagPos1 = pos.method_10093(player.method_5735());
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(player.method_5735());
            boolean canPlace = placeAndUseSleepingBag(player, sleepingBagPos1, sleepingBagPos2, pos, level, player.method_5735());
            if(!canPlace) {
                player.method_43496(class_2561.method_43471(Reference.DEPLOY));
                ((class_3222)player).method_7346();
                return;
            }

            if(!level.field_9236) {
                if(player instanceof class_3222 serverPlayer) {
                    player.method_7269(pos.method_10093(player.method_5735()).method_10093(player.method_5735())).ifLeft(bedSleepingProblem -> {
                        if(bedSleepingProblem.method_19206() != null) {
                            player.method_7353(bedSleepingProblem.method_19206(), true);
                            if(level.method_8320(sleepingBagPos1).method_26204() instanceof SleepingBagBlock) {
                                level.method_8501(sleepingBagPos1, class_2246.field_10124.method_9564());
                            }
                            if(level.method_8320(sleepingBagPos2).method_26204() instanceof SleepingBagBlock) {
                                level.method_8501(sleepingBagPos2, class_2246.field_10124.method_9564());
                            }
                        }
                    });
                    ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, ActionTypeTrigger.USE_SLEEPING_BAG);
                    serverPlayer.method_7346();
                }
            }
        } else {
            if(level.method_8321(pos) instanceof BackpackBlockEntity blockEntity) {
                if(!blockEntity.isSleepingBagDeployed()) {
                    if(!blockEntity.deploySleepingBag(level, pos)) {
                        player.method_43496(class_2561.method_43471(Reference.DEPLOY));
                    }
                } else {
                    blockEntity.removeSleepingBag(level, blockEntity.getBlockDirection());
                }
                if(!level.field_9236) {
                    ((class_3222)player).method_7346();
                }
            }
        }
    }

    public static boolean placeAndUseSleepingBag(class_1657 player, class_2338 sleepingBagPos1, class_2338 sleepingBagPos2, class_2338 pos, class_1937 level, class_2350 direction) {
        if(!player.method_24828() || level.method_8320(sleepingBagPos1.method_10074()).method_26215() || level.method_8320(sleepingBagPos1.method_10074()).method_26204() instanceof class_2404 || !class_2244.method_27352(level)) {
            return false;
        }
        class_1799 backpack = ComponentUtils.getWearingBackpack(player);
        if(BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos2, level) && BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos1, level)) {
            level.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5F, 1.0F);

            if(!level.field_9236) {
                class_2680 sleepingBagState = BackpackBlockEntity.getProperSleepingBag(backpack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, class_1767.field_7964.method_7789()));
                level.method_8652(sleepingBagPos1, sleepingBagState.method_11657(SleepingBagBlock.field_11177, direction).method_11657(SleepingBagBlock.field_9967, class_2742.field_12557).method_11657(SleepingBagBlock.CAN_DROP, false), 3);
                level.method_8652(sleepingBagPos2, sleepingBagState.method_11657(SleepingBagBlock.field_11177, direction).method_11657(SleepingBagBlock.field_9967, class_2742.field_12560).method_11657(SleepingBagBlock.CAN_DROP, false), 3);

                level.method_8452(pos, sleepingBagState.method_26204());
                level.method_8452(sleepingBagPos2, sleepingBagState.method_26204());
            }
            return true;
        }
        return false;
    }

    public static long throwPotion(class_1937 level, class_1657 player, class_1799 potionStack, boolean isSplash) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), isSplash ? class_3417.field_14910 : class_3417.field_14767, class_3419.field_15254, 0.5F, 0.4F / (level.method_8409().method_43057() * 0.4F + 0.8F));

        if(!level.field_9236) {
            class_1686 thrownpotion = new class_1686(level, player);
            thrownpotion.method_16940(potionStack);
            thrownpotion.method_24919(player, player.method_36455(), player.method_36454(), -20.0F, 0.5F, 1.0F);
            level.method_8649(thrownpotion);
        }

        if(!player.method_31549().field_7477) {
            return FluidConstants.BOTTLE;
        }
        return 0;
    }

    public static boolean setFluidEffect(class_1937 level, class_1657 player, FluidTank tank) {
        FluidVariantWrapper fluidStack = tank.getFluid();
        boolean done = false;
        if(EffectFluidRegistry.hasExecutableEffects(fluidStack, level, player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, player, level);
        }
        return done;
    }

    public static void switchHoseMode(class_1657 player, double scrollDelta) {
        class_1799 hose = player.method_6047();
        if(hose.method_7909() instanceof HoseItem) {
            List<Integer> settings = hose.method_57825(ModDataComponents.HOSE_MODES, List.of(1, 1));
            if(scrollDelta > 0) {
                int nextMode = settings.get(0) + 1;
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(nextMode == 4 ? 1 : nextMode, settings.get(1)));
            } else if(scrollDelta < 0) {
                int nextMode = settings.get(0) - 1;
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(nextMode == 0 ? 3 : nextMode, settings.get(1)));
            }
        }

        if(!player.method_37908().field_9236) {
            PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().field_7545, hose, ItemStackUtils.createDataComponentMap(hose, ModDataComponents.HOSE_MODES)));
        }
    }

    public static void toggleHoseTank(class_1657 player) {
        class_1799 hose = player.method_6047();
        if(hose.method_7909() instanceof HoseItem) {
            List<Integer> settings = hose.method_57825(ModDataComponents.HOSE_MODES, List.of(1, 1));
            if(settings.get(1) == 1) {
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(settings.get(0), 2));
            } else {
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(settings.get(0), 1));
            }
        }

        if(!player.method_37908().field_9236) {
            PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().field_7545, hose, ItemStackUtils.createDataComponentMap(hose, ModDataComponents.HOSE_MODES)));
        }
    }
}