package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.compat.comforts.ComfortsCompat;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.components.StarterUpgrades;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.item.upgrades.TanksUpgradeItem;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.world.item.crafting.*;

import java.util.List;

public class ShapedBackpackRecipe extends class_1869 {
    public ShapedBackpackRecipe(String groupIn, class_7710 category, class_8957 shapedRecipePattern, class_1799 recipeOutputIn, boolean pShowNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, pShowNotification);
    }

    @Override
    public class_1799 method_17727(class_9694 pInput, class_7225.class_7874 pRegistries) {
        class_1799 output = this.method_8110(pRegistries).method_7972();

        if(!output.method_7960()) {
            boolean hasTanks = false;
            boolean customBackpack = false;
            for(int i = 0; i < pInput.method_59983(); i++) {
                class_1799 ingredient = pInput.method_59984(i);
                if(ingredient.method_7909() instanceof TravelersBackpackItem) {
                    output.method_57366(ingredient.method_57380());
                    customBackpack = true;
                    //Only for custom backpacks so break here
                    break;
                }

                if(ingredient.method_31573(ModTags.SLEEPING_BAGS)) {
                    int color = getProperColor(ingredient.method_7909());
                    output.method_57379(ModDataComponents.SLEEPING_BAG_COLOR, color);
                }

                if(!hasTanks && ingredient.method_7909() == ModItems.BACKPACK_TANK) {
                    output.method_57379(ModDataComponents.STARTER_UPGRADES, new StarterUpgrades(List.of(ModItems.TANKS_UPGRADE.method_7854())));
                    hasTanks = true;
                }
            }
            if(!customBackpack) {
                output.method_57379(ModDataComponents.STORAGE_SLOTS, Tiers.LEATHER.getStorageSlots());
                if(hasTanks) {
                    output.method_57379(ModDataComponents.RENDER_INFO, TanksUpgradeItem.writeToRenderData());
                } else {
                    output.method_57379(ModDataComponents.RENDER_INFO, RenderInfo.EMPTY);
                }
            }
        }
        return output;
    }

    public static int getProperColor(class_1792 item) {
        if(item instanceof class_1747 blockItem && blockItem.method_7711() instanceof SleepingBagBlock sleepingBagBlock) {
            return sleepingBagBlock.method_9487().method_7789();
        }
        if(TravelersBackpack.comfortsLoaded) {
            return ComfortsCompat.getComfortsSleepingBagColor(item);
        }
        return class_1767.field_7964.method_7789();
    }

    @Override
    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_SHAPED;
    }

    @Override
    public class_3956<?> method_17716() {
        return class_3956.field_17545;
    }

    public static class Serializer implements class_1865<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public static final MapCodec<ShapedBackpackRecipe> CODEC = RecordCodecBuilder.mapCodec(
                p_340778_ -> p_340778_.group(
                                Codec.STRING.optionalFieldOf("group", "").forGetter(p_311729_ -> p_311729_.method_8112()),
                                class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(p_311732_ -> p_311732_.method_45441()),
                                class_8957.field_47321.forGetter(p_311733_ -> p_311733_.field_47320),
                                class_1799.field_51397.fieldOf("result").forGetter(p_311730_ -> p_311730_.field_9053),
                                Codec.BOOL.optionalFieldOf("show_notification", Boolean.valueOf(true)).forGetter(p_311731_ -> p_311731_.method_49188())
                        )
                        .apply(p_340778_, ShapedBackpackRecipe::new)
        );
        public static final class_9139<class_9129, ShapedBackpackRecipe> STREAM_CODEC = class_9139.method_56437(
                Serializer::toNetwork, Serializer::fromNetwork
        );

        @Override
        public MapCodec<ShapedBackpackRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ShapedBackpackRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static ShapedBackpackRecipe fromNetwork(class_9129 p_319998_) {
            String s = p_319998_.method_19772();
            class_7710 craftingbookcategory = p_319998_.method_10818(class_7710.class);
            class_8957 shapedrecipepattern = class_8957.field_48359.decode(p_319998_);
            class_1799 itemstack = class_1799.field_48349.decode(p_319998_);
            boolean flag = p_319998_.readBoolean();
            return new ShapedBackpackRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(class_9129 p_320738_, ShapedBackpackRecipe p_320586_) {
            p_320738_.method_10814(p_320586_.method_8112());
            p_320738_.method_10817(p_320586_.method_45441());
            class_8957.field_48359.encode(p_320738_, p_320586_.field_47320);
            class_1799.field_48349.encode(p_320738_, p_320586_.field_9053);
            p_320738_.method_52964(p_320586_.method_49188());
        }
    }
}