package com.tiviacz.travelersbackpack.compat.jei;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.Internal;
import net.minecraft.class_2960;
import net.minecraft.class_768;
import java.util.ArrayList;
import java.util.List;

@JeiPlugin
public class TravelersBackpackPlugin implements IModPlugin {
    @Override
    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new ItemTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new ItemTransferInfo()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new BlockEntityTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new BlockEntityTransferInfo()), RecipeTypes.CRAFTING);
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BackpackSettingsScreen.class, new IGuiContainerHandler<>() {
            @Override
            public List<class_768> getGuiExtraAreas(BackpackSettingsScreen screen) {
                List<class_768> ret = new ArrayList<>();
                screen.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
                    int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
                    ret.add(new class_768(size[0], size[1], size[2], size[3]));
                });
                return ret;
            }
        });
        registration.addGuiContainerHandler(BackpackScreen.class, new IGuiContainerHandler<>() {
            @Override
            public List<class_768> getGuiExtraAreas(BackpackScreen screen) {
                List<class_768> ret = new ArrayList<>();
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                ret.add(new class_768(s[0], s[1], s[2], s[3]));

                screen.method_25396().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                    int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                    ret.add(new class_768(size[0], size[1], size[2], size[3]));
                });
                screen.upgradeSlots.forEach(slot -> {
                    if(!slot.isHidden()) {
                        int[] size = slot.getUpgradeSlotSizeAndPos();
                        ret.add(new class_768(size[0], size[1], size[2], size[3]));
                    }
                });
                return ret;
            }
        });
    }

    @Override
    public class_2960 getPluginUid() {
        return class_2960.method_60655(TravelersBackpack.MODID, "travelersbackpack");
    }
}