package com.tiviacz.travelersbackpack.compat.universalgraves;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import eu.pb4.graves.GravesApi;
import eu.pb4.graves.grave.GraveInventoryMask;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class UniversalGravesCompat implements GraveInventoryMask {
    public static final GraveInventoryMask INSTANCE = new UniversalGravesCompat();

    public static void register() {
        GravesApi.registerInventoryMask(class_2960.method_60655("universal_graves", "travelers_backpack"), INSTANCE);
    }

    @Override
    public void addToGrave(class_3222 serverPlayerEntity, ItemConsumer itemConsumer) {
        if(TravelersBackpack.enableIntegration()) return;

        if(ComponentUtils.isWearingBackpack(serverPlayerEntity)) {
            class_1799 stack = ComponentUtils.getWearingBackpack(serverPlayerEntity);

            if(GravesApi.canAddItem(serverPlayerEntity, stack)) {
                itemConsumer.addItem(stack, 0);

                ComponentUtils.getComponent(serverPlayerEntity).ifPresent(ITravelersBackpack::remove);

                //Sync
                //ComponentUtils.synchronise(serverPlayerEntity);
            }
        }
    }

    @Override
    public boolean moveToPlayerExactly(class_3222 serverPlayerEntity, class_1799 itemStack, int i, @Nullable class_2520 nbtElement) {
        if(TravelersBackpack.enableIntegration()) return false;

        if(!ComponentUtils.isWearingBackpack(serverPlayerEntity)) {
            class_1799 stack = itemStack.method_7972();
            ComponentUtils.getComponent(serverPlayerEntity).ifPresent(comp -> {
                comp.equipBackpack(stack);
            });

            //Sync
            //ComponentUtils.synchronise(serverPlayerEntity);

            serverPlayerEntity.method_37908().method_8396(null, serverPlayerEntity.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.0F, (1.0F + (serverPlayerEntity.method_37908().field_9229.method_43057() - serverPlayerEntity.method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);

            itemStack.method_7939(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToPlayerClosest(class_3222 serverPlayerEntity, class_1799 itemStack, int i, @Nullable class_2520 nbtElement) {
        return false;
    }
}