package com.tiviacz.travelersbackpack.component;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesCapability;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ComponentUtils implements EntityComponentInitializer {
    public static final ComponentKey<ITravelersBackpack> WEARABLE = ComponentRegistry.getOrCreate(class_2960.method_60655(TravelersBackpack.MODID, "travelersbackpack"), ITravelersBackpack.class);

    @Override
    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(WEARABLE, TravelersBackpackComponent::new, RespawnCopyStrategy.ALWAYS_COPY); //#TODO check
    }

    public static Optional<ITravelersBackpack> getComponent(class_1657 player) {
        if(player == null) {
            return Optional.empty();
        }
        return Optional.of(player.getComponent(WEARABLE));
    }

    public static void synchronise(class_1657 player) {
        if(player instanceof class_3222) {
            getComponent(player).ifPresent(ITravelersBackpack::synchronise);
        }
    }

    public static boolean isWearingBackpack(class_1657 player) {
        if(TravelersBackpack.enableIntegration()) {
            if(TravelersBackpack.enableTrinkets()) {
                if(TrinketsApi.getTrinketComponent(player).isPresent()) {
                    if(TrinketsApi.getTrinketComponent(player).get().isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem)) {
                        return true;
                    }
                }
            }
            if(TravelersBackpack.enableAccessories()) {
                if(AccessoriesCapability.get(player) != null) {
                    if(AccessoriesCapability.get(player).isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem)) {
                        return true;
                    }
                }
            }
            return false;
        }
        if(getComponent(player).isPresent()) {
            return getComponent(player).get().hasBackpack() && getComponent(player).get().getBackpack().method_7909() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static class_1799 getWearingBackpack(class_1657 player) {
        if(TravelersBackpack.enableIntegration()) {
            if(TravelersBackpack.enableTrinkets()) {
                if(TrinketsApi.getTrinketComponent(player).isPresent()) {
                    if(TrinketsApi.getTrinketComponent(player).get().isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem)) {
                        return TrinketsApi.getTrinketComponent(player).get().getEquipped(t -> t.method_7909() instanceof TravelersBackpackItem).getFirst().method_15441();
                    }
                }
            }
            if(TravelersBackpack.enableAccessories()) {
                if(isWearingBackpack(player) && AccessoriesCapability.getOptionally(player).isPresent()) {
                    if(AccessoriesCapability.get(player).getFirstEquipped(t -> t.method_7909() instanceof TravelersBackpackItem) != null) {
                        return AccessoriesCapability.get(player).getFirstEquipped(t -> t.method_7909() instanceof TravelersBackpackItem).stack();
                    }
                }
            }
            return class_1799.field_8037;
        }
        return isWearingBackpack(player) ? getComponent(player).get().getBackpack() : class_1799.field_8037;
    }

    public static void equipBackpack(class_1657 player, class_1799 stack) {
        if(getComponent(player).isPresent() && !isWearingBackpack(player)) {
            getComponent(player).ifPresent(attachment -> attachment.equipBackpack(stack));
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14581.comp_349(), class_3419.field_15248, 1.0F, (1.0F + (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);

            //Sync
            synchronise(player);
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 stack) {
        return getBackpackWrapper(player, stack, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 stack, int[] dataLoad) {
        if(TravelersBackpack.enableIntegration()) {
            if(isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, stack, dataLoad);
            }
            return null;
        }
        if(isWearingBackpack(player)) {
            return ComponentUtils.getComponent(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }

    //Artificial wrapper for actions that do not require loading items
    @Nullable
    public static BackpackWrapper getBackpackWrapperArtificial(class_1657 player) {
        return getBackpackWrapper(player, NO_ITEMS);
    }

    //Fully loaded wrapper
    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player) {
        return getBackpackWrapper(player, LOAD_ALL);
    }

    public static final int[] LOAD_ALL = new int[]{1, 1, 1};
    public static final int[] NO_ITEMS = new int[]{0, 0, 0};
    public static final int[] STORAGE_ONLY = new int[]{1, 0, 0};
    public static final int[] UPGRADES_ONLY = new int[]{0, 1, 0};
    public static final int[] TOOLS_ONLY = new int[]{0, 0, 1};

    //Situational wrapper
    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, int[] dataLoad) {
        if(TravelersBackpack.enableIntegration()) {
            if(isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, getWearingBackpack(player), dataLoad);
            }
            return null;
        }
        if(isWearingBackpack(player)) {
            return ComponentUtils.getComponent(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }
}