package com.tiviacz.travelersbackpack.components;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.util.RegistryHelper;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_3612;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RenderInfo(class_2487 compoundTag) {
    public static final RenderInfo EMPTY = new RenderInfo(new class_2487());
    public static final Codec<RenderInfo> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    class_2487.field_25128.fieldOf("RenderInfo").forGetter(RenderInfo::compoundTag)
            ).apply(instance, RenderInfo::new)
    );
    public static final class_9139<ByteBuf, RenderInfo> STREAM_CODEC = class_9139.method_56434(
            class_9135.method_56368(class_2487.field_25128), RenderInfo::compoundTag, RenderInfo::new
    );

    public boolean isEmpty() {
        return this.compoundTag.method_33133();
    }

    public boolean hasTanks() {
        if(this.compoundTag.method_10545("LeftTank") || this.compoundTag.method_10545("RightTank")) {
            return true;
        }
        return false;
    }

    public FluidVariantWrapper getLeftFluidStack() {
        if(this.compoundTag.method_10545("LeftTank")) {
            if(RegistryHelper.getRegistryAccess().isPresent()) {
                return FluidVariantWrapper.parseOptional(RegistryHelper.getRegistryAccess().get(), this.compoundTag.method_10562("LeftTank"));
            }
        }
        return FluidVariantWrapper.blank();
    }

    public FluidVariantWrapper getRightFluidStack() {
        if(this.compoundTag.method_10545("RightTank")) {
            if(RegistryHelper.getRegistryAccess().isPresent()) {
                return FluidVariantWrapper.parseOptional(RegistryHelper.getRegistryAccess().get(), this.compoundTag.method_10562("RightTank"));
            }
        }
        return FluidVariantWrapper.blank();
    }

    public void updateCapacity(long capacity) {
        if(this.compoundTag.method_10545("Capacity")) {
            this.compoundTag.method_10544("Capacity", capacity);
        }
    }

    public long getCapacity() {
        if(this.compoundTag.method_10545("Capacity")) {
            return this.compoundTag.method_10537("Capacity");
        }
        return 0;
    }

    public static RenderInfo createCreativeTabInfo() {
        class_2487 tag = new class_2487();
        if(RegistryHelper.getRegistryAccess().isPresent()) {
            tag.method_10566("LeftTank", new FluidVariantWrapper(FluidVariant.of(class_3612.field_15910), 1).saveOptional(RegistryHelper.getRegistryAccess().get()));
            tag.method_10566("RightTank", new FluidVariantWrapper(FluidVariant.of(class_3612.field_15908), 1).saveOptional(RegistryHelper.getRegistryAccess().get()));
        }
        tag.method_10544("Capacity", 1);
        return new RenderInfo(tag);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        } else {
            return other instanceof RenderInfo renderInfo ? this.compoundTag.equals(renderInfo.compoundTag) : false;
        }
    }

    @Override
    public int hashCode() {
        return this.compoundTag.hashCode();
    }
}