package com.tiviacz.travelersbackpack.components;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Slots(List<Integer> unsortables, List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
    public static final Slots EMPTY = new Slots(List.of(), List.of());
    public static final Codec<Slots> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                            Codec.INT.listOf().fieldOf("unsortables").forGetter(Slots::unsortables),
                            Codec.mapPair(Codec.INT.fieldOf("index"), Codec.mapPair(class_1799.field_49266.fieldOf("item"), Codec.BOOL.fieldOf("matchComponents"))).codec().listOf().fieldOf("memory").forGetter(Slots::memory))
                    .apply(instance, Slots::new)
    );

    public static final class_9139<class_9129, Slots> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675.method_56433(class_9135.method_56363()), Slots::unsortables,
            class_9135.method_56896(Codec.mapPair(Codec.INT.fieldOf("index"), Codec.mapPair(class_1799.field_49266.fieldOf("item"), Codec.BOOL.fieldOf("matchComponents"))).codec()).method_56433(class_9135.method_56363()), Slots::memory,
            Slots::new
    );

    public static Slots updateUnsortables(Slots oldSlots, List<Integer> data) {
        return new Slots(data, oldSlots.memory());
    }

    public static Slots updateMemory(Slots oldSlots, List<Pair<Integer, Pair<class_1799, Boolean>>> data) {
        return new Slots(oldSlots.unsortables(), data);
    }

    public List<Integer> unsortables() {
        return unsortables;
    }

    public List<Pair<Integer, Pair<class_1799, Boolean>>> memory() {
        return memory;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj) {
            return true;
        } else if(!(obj instanceof Slots o)) {
            return false;
        } else {
            return this.unsortables.equals(o.unsortables) && memoryMatch(o.memory);
        }
    }

    public boolean memoryMatch(List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
        if(this.memory.size() != memory.size()) {
            return false;
        }

        for(int i = 0; i < this.memory.size(); i++) {
            Pair<Integer, Pair<class_1799, Boolean>> thisEntry = this.memory.get(i);
            Pair<Integer, Pair<class_1799, Boolean>> otherEntry = memory.get(i);

            if(!thisEntry.getFirst().equals(otherEntry.getFirst())) {
                return false;
            }

            Pair<class_1799, Boolean> thisPair = thisEntry.getSecond();
            Pair<class_1799, Boolean> otherPair = otherEntry.getSecond();

            if(!thisPair.getSecond().equals(otherPair.getSecond())) {
                return false;
            }

            if(thisPair.getSecond()) {
                if(!class_1799.method_7973(thisPair.getFirst(), otherPair.getFirst())) {
                    return false;
                }
            }
        }

        return true;
    }

    @Override
    public int hashCode() {
        return hashSlots(this.unsortables, this.memory);
    }

    public static int hashSlots(List<Integer> unsortables, List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
        int hash = 0;
        for(Integer i : unsortables) {
            hash = 31 * hash + (i != null ? i.hashCode() : 0);
        }

        for(Pair<Integer, Pair<class_1799, Boolean>> entry : memory) {
            int innerHash = 0;

            innerHash = 31 * innerHash + (entry.getFirst() != null ? entry.getFirst().hashCode() : 0);

            Pair<class_1799, Boolean> innerPair = entry.getSecond();
            innerHash = 31 * innerHash + class_1799.method_57355(innerPair.getFirst());
            innerHash = 31 * innerHash + (innerPair.getSecond() != null ? innerPair.getSecond().hashCode() : 0);

            hash = 31 * hash + innerHash;
        }

        return hash;
    }
}