package com.tiviacz.travelersbackpack.fluids;

import com.tiviacz.travelersbackpack.init.ModFluids;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;

public abstract class PotionFluid extends class_3609 {
    @Override
    public class_3609 method_15750() {
        return ModFluids.POTION_FLOWING;
    }

    @Override
    public class_3609 method_15751() {
        return ModFluids.POTION_STILL;
    }

    @Override
    public class_1792 method_15774() {
        return class_1802.field_8162;
    }

    @Override
    @Nullable
    public class_2394 method_15787() {
        return class_2398.field_11232;
    }

    @Override
    protected void method_15730(class_1936 level, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? level.method_8321(pos) : null;
        class_2248.method_9610(state, level, pos, blockEntity);
    }

    @Override
    public int method_15733(class_4538 level) {
        return 4;
    }

    @Override
    public class_2680 method_15790(class_3610 state) {
        return class_2246.field_10124.method_9564();
    }

    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == ModFluids.POTION_STILL || fluid == ModFluids.POTION_FLOWING;
    }

    @Override
    public int method_15739(class_4538 level) {
        return 1;
    }

    @Override
    public int method_15789(class_4538 level) {
        return 5;
    }

    @Override
    public boolean method_15777(class_3610 state, class_1922 level, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return direction == class_2350.field_11033 && !method_15780(fluid);
    }

    @Override
    protected float method_15784() {
        return 100.0F;
    }

    @Override
    public Optional<class_3414> method_32359() {
        return Optional.of(class_3417.field_15126);
    }

    public static class Flowing extends PotionFluid {

        @Override
        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(field_15900);
        }

        @Override
        protected boolean method_15737(class_1937 level) {
            return false;
        }

        @Override
        public boolean method_15793(class_3610 state) {
            return false;
        }

        @Override
        public int method_15779(class_3610 state) {
            return 0;
        }
    }

    public static class Still extends PotionFluid {

        @Override
        protected boolean method_15737(class_1937 level) {
            return false;
        }

        @Override
        public boolean method_15793(class_3610 state) {
            return true;
        }

        @Override
        public int method_15779(class_3610 state) {
            return 0;
        }
    }
}