package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.client.model.BackpackUnbakedModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import java.util.HashSet;
import java.util.Set;

@Environment(EnvType.CLIENT)
public class BackpackModelLoadingPlugin implements ModelLoadingPlugin {

    private static final Set<class_1091> BACKPACK_MODELS = new HashSet<>();
    private static final Set<class_1091> BACKPACK_ITEM_MODELS = new HashSet<>();

    static {
        for (class_2248 block : class_7923.field_41175) {
            if (block instanceof TravelersBackpackBlock) {
                class_2960 blockId = class_7923.field_41175.method_10221(block);
                for (class_2680 state : block.method_9595().method_11662()) {
                    class_1091 modelId = class_773.method_3336(blockId, state);
                    BACKPACK_MODELS.add(modelId);
                }
                BACKPACK_ITEM_MODELS.add(new class_1091(blockId, "inventory"));
            }
        }
    }

    @Override
    public void onInitializeModelLoader(Context pluginContext) {
        // We want to add our model when the models are loaded
        pluginContext.modifyModelOnLoad().register((original, context) -> {
            // This is called for every model that is loaded, so make sure we only target ours
            class_1091 id = context.topLevelId();
            if (id != null && (BACKPACK_MODELS.contains(id) || BACKPACK_ITEM_MODELS.contains(id))) {
                return new BackpackUnbakedModel(original);
            } else {
                // If we don't modify the model we just return the original as-is
                return original;
            }
        });
    }
}