package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3222;

public class DeathHandler {
    public static void registerListeners() {
        ServerLivingEntityEvents.ALLOW_DEATH.register((livingEntity, damageSource, damageAmount) -> {
            if(livingEntity instanceof class_3222 player) {
                if(BackpackAbilities.ABILITIES.checkBackpack(player, ModItems.CREEPER_TRAVELERS_BACKPACK)) {
                    if(BackpackAbilities.creeperAbility(player)) {
                        return false;
                    }
                }
            }
            return true;
        });

        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            if(livingEntity instanceof class_3222 player) {
                if(ComponentUtils.isWearingBackpack(player)) {
                    //If integration detected, then do not use this logic, it will be handled by the integration/added to the grave
                    if(TravelersBackpack.enableIntegration()) {
                        return;
                    }

                    //Keep backpack on with Keep Inventory game rule
                    if(player.method_37908().method_8450().method_8355(class_1928.field_19389)) return;

                    class_1799 stack = ComponentUtils.getWearingBackpack(player);

                    if(BackpackDeathHelper.onPlayerDrops(player.method_37908(), player, stack)) {
                        if(player.method_37908().field_9236) return;

                        class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack);
                        itemEntity.method_6988();

                        PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSendMessagePacket(true, player.method_24515()));
                        LogHelper.info("There's no space for backpack. Dropping backpack item at" + " X: " + player.method_24515().method_10263() + " Y: " + player.method_23318() + " Z: " + player.method_24515().method_10260());

                        player.method_37908().method_8649(itemEntity);

                        ComponentUtils.getComponent(player).ifPresent(attachment -> {
                            attachment.remove();
                            attachment.synchronise();
                        });
                        return;
                    }
                }
            }
            if(TravelersBackpackConfig.isOverworldEntityTypePossible(livingEntity) || TravelersBackpackConfig.isNetherEntityTypePossible(livingEntity)) {
                if(livingEntity.method_6118(class_1304.field_6174).method_7909() instanceof TravelersBackpackItem) {
                    if(!(damageSource.method_5526() instanceof class_1657)) return;

                    class_1542 itemEntity = new class_1542(livingEntity.method_37908(), livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), livingEntity.method_6118(class_1304.field_6174));
                    livingEntity.method_37908().method_8649(itemEntity);
                }
            }
        });
    }
}
