package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.item.HoseItem;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import org.lwjgl.glfw.GLFW;

public class KeybindHandler {
    public static final class_2960 TRAVELERS_BACKPACK_PHASE = class_2960.method_60655(TravelersBackpack.MODID, "phase");
    private static final String CATEGORY = "key.travelersbackpack.category";
    public static final class_304 OPEN_BACKPACK = new class_304("key.travelersbackpack.inventory", class_3675.class_307.field_1668, GLFW.GLFW_KEY_B, CATEGORY);
    public static final class_304 SORT_BACKPACK = new class_304("key.travelersbackpack.sort", class_3675.class_307.field_1668, GLFW.GLFW_KEY_UNKNOWN, CATEGORY);
    public static final class_304 ABILITY = new class_304("key.travelersbackpack.ability", class_3675.class_307.field_1668, GLFW.GLFW_KEY_UNKNOWN, CATEGORY);
    public static final class_304 SWITCH_TOOL = new class_304("key.travelersbackpack.cycle_tool", class_3675.class_307.field_1668, GLFW.GLFW_KEY_Z, CATEGORY);
    public static final class_304 TOGGLE_TANK = new class_304("key.travelersbackpack.toggle_tank", class_3675.class_307.field_1668, GLFW.GLFW_KEY_N, CATEGORY);

    public static void initKeybinds() {
        KeyBindingHelper.registerKeyBinding(OPEN_BACKPACK);
        KeyBindingHelper.registerKeyBinding(SORT_BACKPACK);
        KeyBindingHelper.registerKeyBinding(ABILITY);
        KeyBindingHelper.registerKeyBinding(SWITCH_TOOL);
        KeyBindingHelper.registerKeyBinding(TOGGLE_TANK);
    }

    public static void registerListener() {
        ClientTickEvents.START_CLIENT_TICK.addPhaseOrdering(TRAVELERS_BACKPACK_PHASE, Event.DEFAULT_PHASE);

        ClientTickEvents.START_CLIENT_TICK.register(TRAVELERS_BACKPACK_PHASE, evt -> {
            class_1657 player = class_310.method_1551().field_1724;
            if(player == null) return;
            //Change Hose Tank Assignment
            if(player.method_6047().method_7909() instanceof HoseItem && player.method_6047().method_57826(ModDataComponents.HOSE_MODES)) {
                while(KeybindHandler.TOGGLE_TANK.method_1436()) {
                    ServerboundActionTagPacket.create(ServerboundActionTagPacket.SWITCH_HOSE_TANK);
                }
            }
            //Change Hose modes
            if(TravelersBackpackConfig.getConfig().client.disableScrollWheel) {
                class_1799 heldItem = player.method_6047();
                if(!ToolSlotItemHandler.isValid(heldItem)) {
                    while(KeybindHandler.SWITCH_TOOL.method_1436()) {
                        if(!heldItem.method_7960()) {
                            if(heldItem.method_7909() instanceof HoseItem && heldItem.method_57826(ModDataComponents.HOSE_MODES)) {
                                ServerboundActionTagPacket.create(ServerboundActionTagPacket.SWITCH_HOSE_MODE, 1.0D);
                            }
                        }
                    }
                }
            }
            if(ComponentUtils.isWearingBackpack(player)) {
                while(KeybindHandler.OPEN_BACKPACK.method_1436()) {
                    ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_SCREEN);
                }
                while(KeybindHandler.ABILITY.method_1436()) {
                    if(BackpackAbilities.ALLOWED_ABILITIES.contains(ComponentUtils.getWearingBackpack(player).method_7909())) {
                        boolean ability = ComponentUtils.getBackpackWrapperArtificial(player).isAbilityEnabled();
                        ServerboundActionTagPacket.create(ServerboundActionTagPacket.ABILITY_SLIDER, !ability);
                        player.method_7353(class_2561.method_43471(ability ? "screen.travelersbackpack.ability_disabled" : "screen.travelersbackpack.ability_enabled"), true);
                    }
                }
                if(TravelersBackpackConfig.getConfig().client.disableScrollWheel) {
                    class_1799 heldItem = player.method_6047();
                    while(KeybindHandler.SWITCH_TOOL.method_1436()) {
                        if(!heldItem.method_7960()) {
                            if(TravelersBackpackConfig.getConfig().client.enableToolCycling) {
                                if(ToolSlotItemHandler.isValid(heldItem)) {
                                    ServerboundActionTagPacket.create(ServerboundActionTagPacket.SWAP_TOOL, 1.0D);
                                }
                            }
                        }
                    }
                }
            } else {
                while(KeybindHandler.OPEN_BACKPACK.method_1436()) {
                    for(int i = 0; i < player.method_31548().field_7547.size(); i++) {
                        class_1799 stack = player.method_31548().field_7547.get(i);
                        if(stack.method_7909() instanceof TravelersBackpackItem) {
                            ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_BACKPACK, i, false);
                            break;
                        }
                    }
                }
            }
        });

        ScreenEvents.BEFORE_INIT.register(((client, screen, scaledWidth, scaledHeight) -> {
            ScreenKeyboardEvents.beforeKeyPress(screen).register((gui, keyCode, scanCode, modifiers) -> {
                if(!TravelersBackpackConfig.getConfig().backpackSettings.allowOpeningFromSlot) {
                    return;
                }
                if(screen instanceof class_465<?> containerScreen && client.field_1724 != null) {
                    if(KeybindHandler.OPEN_BACKPACK.method_1417(keyCode, scanCode)) {
                        class_1735 slot = containerScreen.field_2787;
                        if(slot != null && slot.method_7677().method_7909() instanceof TravelersBackpackItem && slot.method_32754(client.field_1724) && slot.field_7871 instanceof class_1661) {
                            ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_BACKPACK, slot.method_34266(), true);
                        }
                    }
                }
            });
        }));
    }

    public static boolean mouseWheelDetect(double mouseX, double mouseY) {
        class_310 mc = class_310.method_1551();
        double scrollDelta = mouseY;
        if(!TravelersBackpackConfig.getConfig().client.disableScrollWheel && scrollDelta != 0.0) {
            class_1657 player = mc.field_1724;
            if(player != null && player.method_5805() && KeybindHandler.SWITCH_TOOL.method_1434()) {
                class_1799 heldItem = player.method_6047();
                if(!heldItem.method_7960()) {
                    if(heldItem.method_7909() instanceof HoseItem && heldItem.method_57826(ModDataComponents.HOSE_MODES)) {
                        ServerboundActionTagPacket.create(ServerboundActionTagPacket.SWITCH_HOSE_MODE, scrollDelta);
                        return true;
                        // event.setCanceled(true);
                    }
                    if(ComponentUtils.isWearingBackpack(player) && TravelersBackpackConfig.getConfig().client.enableToolCycling) {
                        if(ToolSlotItemHandler.isValid(heldItem)) {
                            ServerboundActionTagPacket.create(ServerboundActionTagPacket.SWAP_TOOL, scrollDelta);
                            return true;
                            // event.setCanceled(true);
                        }
                    }
                }
            }
        }
        return false;
    }
}