package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.network.ServerboundRetrieveBackpackPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_5632;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ScreenRenderHandler {
    public static void registerScreenEvents() {
        ScreenEvents.AFTER_INIT.register(((client, screen2, scaledWidth, scaledHeight) -> {
            class_1657 player = client.field_1724;
            if(player == null) return;

            //Draw + and - for items that can be inserted to backpack
            if(screen2 instanceof class_465<?> screen) {
                ScreenEvents.afterRender(screen).register((screen1, guiGraphics, mouseX, mouseY, tickDelta) -> {
                    if(!TravelersBackpackItem.isCreative(player)) {
                        var menu = screen.method_17577();
                        class_1799 carried = menu.method_34255();
                        class_1735 hoveredSlot = screen.field_2787;
                        Optional<class_5632> tooltip = Optional.empty();

                        guiGraphics.method_51448().method_22903();
                        guiGraphics.method_51448().method_46416((float)screen.field_2776, (float)screen.field_2800, 350.0F);

                        for(class_1735 slot : menu.field_7761) {
                            class_1799 slotStack = slot.method_7677();
                            if(carried.method_7909() instanceof TravelersBackpackItem) {
                                tooltip = Optional.of(new BackpackTooltipComponent(carried, true));
                                if(!slotStack.method_7960() && slot.method_7674(player) && BackpackSlotItemHandler.isItemValid(slotStack)) {
                                    guiGraphics.method_25303(client.field_1772, "-", slot.field_7873 + 2, slot.field_7872 - 1, class_124.field_1054.method_532().intValue()); //16109090
                                    if(slot == hoveredSlot) {
                                        renderBackpackTooltipOnHover(guiGraphics, mouseX, mouseY, client, tooltip, (float)screen.field_2776, (float)screen.field_2800, 350.0F);
                                    }
                                }
                            } else if(!carried.method_7960() && BackpackSlotItemHandler.isItemValid(carried)) {
                                if(slotStack.method_7909() instanceof TravelersBackpackItem && slot.method_32754(player)) {
                                    tooltip = Optional.of(new BackpackTooltipComponent(slotStack, true));
                                    guiGraphics.method_25303(client.field_1772, "+", slot.field_7873 + 9, slot.field_7872 + 8, class_124.field_1054.method_532().intValue()); //16109090
                                    if(slot == hoveredSlot) {
                                        renderBackpackTooltipOnHover(guiGraphics, mouseX, mouseY, client, tooltip, (float)screen.field_2776, (float)screen.field_2800, 350.0F);
                                    }
                                }
                            }
                        }
                        guiGraphics.method_51448().method_22909();
                    }
                });
            }

            if(screen2 instanceof class_490 screen) {
                ScreenEvents.afterRender(screen).register((screen1, guiGraphics, mouseX, mouseY, tickDelta) -> {
                    //Render Backpack Icon if Backpack is equipped in Capability but Integration is enabled to easily retrieve the backpack
                    if(class_310.method_1551().field_1755 instanceof class_490 && ComponentUtils.getComponent(player).isPresent()) {
                        if(ComponentUtils.getComponent(player).get().hasBackpack() && TravelersBackpack.enableIntegration()) {
                            class_1799 backpack = ComponentUtils.getComponent(player).get().getBackpack();
                            guiGraphics.method_51427(backpack, screen.field_2776 + 77, screen.field_2800 + 62 - 18);

                            if(mouseX >= screen.field_2776 + 77 && mouseX < screen.field_2776 + 77 + 16 && mouseY >= screen.field_2800 + 62 - 18 && mouseY < screen.field_2800 + 62 - 18 + 16) {
                                class_465.method_33285(guiGraphics, screen.field_2776 + 77, screen.field_2800 + 62 - 18, -1000);
                                List<class_2561> components = new ArrayList<>();
                                components.add(class_2561.method_43471("screen.travelersbackpack.retrieve_backpack"));
                                guiGraphics.method_51437(class_310.method_1551().field_1772, components, Optional.of(new BackpackTooltipComponent(backpack)), mouseX, mouseY);
                            }
                        }
                    }

                    if(!TravelersBackpackConfig.getConfig().client.showBackpackIconInInventory) return;

                    if(ComponentUtils.isWearingBackpack(player)) {
                        if(TravelersBackpack.enableIntegration()) return;

                        class_1799 backpack = ComponentUtils.getWearingBackpack(player);
                        guiGraphics.method_51427(backpack, screen.field_2776 + 77, screen.field_2800 + 62 - 18);

                        if(mouseX >= screen.field_2776 + 77 && mouseX < screen.field_2776 + 77 + 16 && mouseY >= screen.field_2800 + 62 - 18 && mouseY < screen.field_2800 + 62 - 18 + 16) {
                            class_485.method_33285(guiGraphics, screen.field_2776 + 77, screen.field_2800 + 62 - 18, -1000);
                            String button = KeybindHandler.OPEN_BACKPACK.method_16007().getString();
                            List<class_2561> components = new ArrayList<>();
                            components.add(class_2561.method_43469("screen.travelersbackpack.open_inventory", button));
                            components.add(class_2561.method_43471("screen.travelersbackpack.unequip_tip"));
                            components.add(class_2561.method_43471("screen.travelersbackpack.hide_icon"));
                            class_1836.class_1837 tooltipflag$default = class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
                            backpack.method_7909().method_7851(backpack, class_1792.class_9635.method_59528(player.method_37908()), components, tooltipflag$default);
                            guiGraphics.method_51437(class_310.method_1551().field_1772, components, Optional.of(new BackpackTooltipComponent(backpack)), mouseX, mouseY);
                        }
                    }
                });

                ScreenMouseEvents.afterMouseClick(screen).register((screen1, mouseX, mouseY, button) -> {
                    //Render Backpack Icon if Backpack is equipped in Capability but Integration is enabled to easily retrieve the backpack
                    if(class_310.method_1551().field_1755 instanceof class_490 && ComponentUtils.getComponent(player).isPresent()) {
                        if(ComponentUtils.getComponent(player).get().hasBackpack() && TravelersBackpack.enableIntegration()) {
                            if(mouseX >= screen.field_2776 + 77 && mouseX < screen.field_2776 + 77 + 16 && mouseY >= screen.field_2800 + 62 - 18 && mouseY < screen.field_2800 + 62 - 18 + 16) {
                                if(button == GLFW.GLFW_MOUSE_BUTTON_1) {
                                    PacketDistributor.sendToServer(new ServerboundRetrieveBackpackPacket(ComponentUtils.getComponent(player).get().getBackpack().method_7909().method_7854()));
                                }
                            }
                        }
                    }

                    if(!TravelersBackpackConfig.getConfig().client.showBackpackIconInInventory) return;

                    if(ComponentUtils.isWearingBackpack(player)) {
                        if(TravelersBackpack.enableIntegration()) return;

                        if(mouseX >= screen.field_2776 + 77 && mouseX < screen.field_2776 + 77 + 16 && mouseY >= screen.field_2800 + 62 - 18 && mouseY < screen.field_2800 + 62 - 18 + 16) {
                            if(button == GLFW.GLFW_MOUSE_BUTTON_1) {
                                if(class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), GLFW.GLFW_KEY_LEFT_SHIFT)) {
                                    player.method_43496(class_2561.method_43471("screen.travelersbackpack.hide_icon_info"));
                                } else {
                                    ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_SCREEN);
                                }
                            }
                        }
                    }
                });
            }
        }));
    }

    private static void renderBackpackTooltipOnHover(class_332 guiGraphics, int mouseX, int mouseY, class_310 mc, Optional<class_5632> component, float fx, float fy, float fz) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(-fx, -fy, -fz);
        poseStack.method_46416(0, 0, 100);
        guiGraphics.method_51437(mc.field_1772, List.of(class_2561.method_43471("screen.travelersbackpack.add_to_backpack").method_27692(class_124.field_1054)), component, mouseX, mouseY);
        poseStack.method_22909();
    }
}