package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class SleepHandler {
    public static void registerListener() {
        //Handled in SleepingBagBlock to create forced spawn point
        EntitySleepEvents.ALLOW_SETTING_SPAWN.register((player, sleepingPos) -> !(!player.method_37908().field_9236 && player.method_37908().method_8320(sleepingPos).method_26204() instanceof SleepingBagBlock));

        EntitySleepEvents.STOP_SLEEPING.register((player, sleepingPos) -> {
            if(!TravelersBackpackConfig.getConfig().backpackSettings.quickSleepingBag) {
                return;
            }
            class_1937 level = player.method_37908();
            if(level.method_8320(sleepingPos).method_26204() instanceof SleepingBagBlock) {
                class_2680 headPart = level.method_8320(sleepingPos);
                if(headPart.method_28498(SleepingBagBlock.CAN_DROP) && headPart.method_11654(SleepingBagBlock.CAN_DROP)) {
                    return;
                }
                class_2338 backpackPos = sleepingPos.method_10079(headPart.method_11654(SleepingBagBlock.field_11177).method_10153(), 2);
                if(!(level.method_8320(backpackPos).method_26204() instanceof TravelersBackpackBlock)) {
                    if(!level.field_9236) {
                        level.method_8501(sleepingPos, class_2246.field_10124.method_9564());
                    }
                }
            }
        });
    }
}