package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.TravelersBackpackComponent;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentProvider;

public class BackpackContainer {
    public final class_1799 stack;
    public final class_1657 player;
    public final int screenID;
    public final int index;

    public BackpackContainer(class_1799 stack, class_1657 player, int screenID) {
        this(stack, player, screenID, -1);
    }

    public BackpackContainer(class_1799 stack, class_1657 player, int screenID, int index) {
        this.stack = stack;
        this.player = player;
        this.screenID = screenID;
        this.index = index;
    }

    public static ModScreenHandlerTypes.ItemScreenData saveExtraData(@Nullable class_1657 target, int screenID) {
        return new ModScreenHandlerTypes.ItemScreenData(screenID, target == null ? -1 : target.method_5628());
    }

    public static ModScreenHandlerTypes.ItemScreenData saveExtraData(int index, int screenID) {
        return new ModScreenHandlerTypes.ItemScreenData(screenID, index);
    }

    //Component
    public static void openBackpack(class_3222 serverPlayerEntity, class_1799 stack, int screenID) {
        if(!serverPlayerEntity.method_37908().field_9236) {
            serverPlayerEntity.method_17355(new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.ItemScreenData>() {
                @Override
                public class_2561 method_5476() {
                    return class_2561.method_43471("screen.travelersbackpack.item");
                }

                @Override
                public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if(screenID == Reference.WEARABLE_SCREEN_ID) {
                        return new BackpackItemMenu(i, inventory, ComponentUtils.getBackpackWrapper(player));
                    } else {
                        return new BackpackItemMenu(i, inventory, new BackpackWrapper(stack, screenID, player, player.method_37908()));
                    }
                }

                @Override
                public ModScreenHandlerTypes.ItemScreenData getScreenOpeningData(class_3222 player) {
                    return saveExtraData(null, screenID);
                }
            });
        }
    }

    //Item
    public static void openBackpack(class_3222 serverPlayerEntity, class_1799 stack, int screenID, int index) {
        if(!serverPlayerEntity.method_37908().field_9236) {
            serverPlayerEntity.method_17355(new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.ItemScreenData>() {
                @Override
                public class_2561 method_5476() {
                    return class_2561.method_43471("screen.travelersbackpack.item");
                }

                @Override
                public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if(screenID == Reference.WEARABLE_SCREEN_ID) {
                        return new BackpackItemMenu(i, inventory, ComponentUtils.getBackpackWrapper(player));
                    } else {
                        return new BackpackItemMenu(i, inventory, new BackpackWrapper(stack, screenID, player, player.method_37908(), index));
                    }
                }

                @Override
                public ModScreenHandlerTypes.ItemScreenData getScreenOpeningData(class_3222 player) {
                    return saveExtraData(index, screenID);
                }
            });
        }
    }

    public static void openAnotherPlayerBackpack(class_3222 opener, class_3222 targetPlayer, class_1799 stack, int screenID) {
        if(!opener.method_37908().field_9236) {
            synchroniseToOpener(opener, targetPlayer);
            opener.method_17355(new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.ItemScreenData>() {
                @Override
                public class_2561 method_5476() {
                    return class_2561.method_43471("screen.travelersbackpack.item");
                }

                @Override
                public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if(screenID == Reference.WEARABLE_SCREEN_ID) {
                        return new BackpackItemMenu(i, inventory, ComponentUtils.getBackpackWrapper(targetPlayer));
                    } else {
                        return new BackpackItemMenu(i, inventory, new BackpackWrapper(stack, screenID, player, player.method_37908()));
                    }
                }

                @Override
                public ModScreenHandlerTypes.ItemScreenData getScreenOpeningData(class_3222 player) {
                    return saveExtraData(targetPlayer, screenID);
                }
            });
        }
    }

    public static void synchroniseToOpener(class_3222 opener, class_3222 target) {
        if(opener != null) { //Sync data from target to opener
            ComponentUtils.WEARABLE.syncWith(opener, (ComponentProvider)target, (buf, rec) -> ((TravelersBackpackComponent)ComponentUtils.WEARABLE.get(target)).writeSyncPacket(ComponentUtils.getWearingBackpack(target), buf, rec, false), p -> true);
        }
    }
}