package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class BackpackSettingsContainer {
    public final class_1799 stack;
    public final class_1657 player;
    public final int screenID;
    public final int index;

    public BackpackSettingsContainer(class_1799 stack, class_1657 player, int screenID, int index) {
        this.stack = stack;
        this.player = player;
        this.screenID = screenID;
        this.index = index;
    }

    public static ModScreenHandlerTypes.SettingsScreenData saveSettingsExtraData(int screenID, int index) {
        return new ModScreenHandlerTypes.SettingsScreenData(false, screenID, class_2338.field_10980, index);
    }

    public static void openSettings(class_3222 serverPlayerEntity, class_1799 stack, int screenID, int index) {
        if(!serverPlayerEntity.method_37908().field_9236) {
            serverPlayerEntity.method_17355(new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.SettingsScreenData>() {
                @Override
                public class_2561 method_5476() {
                    return class_2561.method_43471("screen.travelersbackpack.item");
                }

                @Override
                public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if(screenID == Reference.WEARABLE_SCREEN_ID) {
                        return new BackpackSettingsMenu(i, inventory, ComponentUtils.getBackpackWrapper(player));
                    } else {
                        return new BackpackSettingsMenu(i, inventory, new BackpackWrapper(stack, screenID, player, player.method_37908(), index));
                    }
                }

                @Override
                public ModScreenHandlerTypes.SettingsScreenData getScreenOpeningData(class_3222 player) {
                    return saveSettingsExtraData(screenID, index);
                }
            });
        }
    }
}