package com.tiviacz.travelersbackpack.inventory.handler;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

/**
 * Custom ItemStackHandler for Traveler's Backpack block entity interactions with hoppers, pipes etc. that respects unsortable and memory slots :)
 */
public class StorageAccessWrapper extends ItemStackHandler {
    public final BackpackWrapper wrapper;
    public final ItemStackHandler parent;

    public StorageAccessWrapper(BackpackWrapper wrapper, ItemStackHandler parent) {
        this.wrapper = wrapper;
        this.parent = parent;
    }

    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        parent.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return parent.getSlots();
    }

    public @NotNull class_1799 getStackInSlot(int slot) {
        return parent.getStackInSlot(slot);
    }

    public @NotNull class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        //Voiding
        if(tryVoiding(stack)) {
            if(!simulate) {
                return class_1799.field_8037;
            }
        }
        //Try inserting to memory slots first
        if(!wrapper.getMemorySlots().isEmpty()) {
            for(Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : wrapper.getMemorySlots()) {
                if(memorizedStack.getSecond().getFirst().method_7909() != stack.method_7909()) {
                    continue;
                }
                int result = matchesStack(stack, memorizedStack);
                if(result != -1) {
                    stack = parent.insertItem(result, stack, simulate);
                    if(stack.method_7960()) {
                        return class_1799.field_8037;
                    }
                }
            }
        }
        return wrapper.getUnsortableSlots().contains(slot) ? stack : parent.insertItem(slot, stack, simulate);
    }

    public int matchesStack(class_1799 inserted, Pair<Integer, Pair<class_1799, Boolean>> memorizedStack) {
        if(memorizedStack.getSecond().getSecond()) {
            return ItemStackUtils.isSameItemSameTags(inserted, memorizedStack.getSecond().getFirst()) ? memorizedStack.getFirst() : -1;
        } else {
            return class_1799.method_7984(inserted, memorizedStack.getSecond().getFirst()) ? memorizedStack.getFirst() : -1;
        }
    }

    public boolean tryVoiding(class_1799 stack) {
        return wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).map(voidUpgrade -> voidUpgrade.canVoid(stack)).orElse(false);
    }

    public @NotNull class_1799 extractItem(int slot, int amount, boolean simulate) {
        return wrapper.getUnsortableSlots().contains(slot) ? class_1799.field_8037 : parent.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return parent.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return parent.isItemValid(slot, stack);
    }

    @Override
    public boolean method_49104(class_1263 target, int slot, class_1799 stack) {
        if(wrapper.getUnsortableSlots().contains(slot)) {
            return false;
        }
        return true;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if(isItemValid(slot, stack)) {
            if(wrapper.getUnsortableSlots().contains(slot)) {
                if(!wrapper.getMemorySlots().isEmpty()) {
                    for(Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : wrapper.getMemorySlots()) {
                        if(memorizedStack.getFirst() == slot) {
                            return true;
                        }
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int method_5439() {
        return getSlots();
    }

    @Override
    public boolean method_5442() {
        return InventoryHelper.isEmpty(this);
    }

    @Override
    public class_1799 method_5438(int slot) {
        return getStackInSlot(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return extractItem(slot, amount, false);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return extractItem(slot, getStackInSlot(slot).method_7947(), false);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        setStackInSlot(slot, stack);
    }

    @Override
    public void method_5431() {
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public void method_5448() {
        this.stacks.clear();
    }
}
