package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.*;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9694;

public class BackpackBaseMenu extends AbstractBackpackMenu {
    public List<UpgradeLockableSlotItemHandler> upgradeSlot = new ArrayList<>();
    public int unmodifiableSlotCount = 0;

    public int TOOL_START, TOOL_END;
    public int UPGRADE_START, UPGRADE_END;
    public int BUCKET_LEFT_IN, BUCKET_LEFT_OUT;
    public int BUCKET_RIGHT_IN, BUCKET_RIGHT_OUT;
    public int CRAFTING_RESULT;
    public int CRAFTING_GRID_START, CRAFTING_GRID_END;

    public BackpackBaseMenu(class_3917<?> type, int windowID, class_1661 inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    //Add all slots - menu initialization
    public void addSlots() {
        if(this.wrapper.tanksVisible()) {
            extendedScreenOffset = 22;
        }

        //Storage Slots
        this.addBackpackStorageSlots(wrapper);
        this.BACKPACK_INV_END = this.field_7761.size();

        //Tool Slots
        this.TOOL_START = this.field_7761.size();
        this.addBackpackToolSlots(wrapper);
        this.TOOL_END = this.field_7761.size();

        //Upgrades
        this.UPGRADE_START = this.field_7761.size();
        this.addBackpackUpgradeSlots(wrapper);
        this.UPGRADE_END = this.field_7761.size();

        //Player Inventory
        this.PLAYER_INV_START = this.field_7761.size();
        this.addPlayerInventoryAndHotbar(inventory, getWrapper().getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.field_7761.size();

        this.unmodifiableSlotCount = this.field_7761.size();

        //Listeners
        this.addUpgradeListeners();

        //Upgrades
        this.addUpgradeSlots(wrapper);
    }

    //Update storage, player, upgrade slots
    //Add slots that can be modified - slots from upgrades
    public void addModifiableSlots() {
        if(this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }

        //Update Player Slots, Storage Slots
        this.updateSlotsPosition();

        //Update Upgrade Slots
        this.updateBackpackUpgradeSlots();

        //Listeners from Upgrades
        this.addUpgradeListeners();

        //Slots from Upgrades
        this.addUpgradeSlots(wrapper);

        //Update result slot on client
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> canCraft(inventory.field_7546.method_37908(), inventory.field_7546));
    }

    //Reset Modifiable slots - remove slots if upgrades removed
    public void updateModifiableSlots() {
        this.extendedScreenOffset = 0;

        if(this.field_7764.size() > this.unmodifiableSlotCount) {
            this.field_7764.subList(this.unmodifiableSlotCount, this.field_7764.size()).clear();
        }
        if(this.field_7761.size() > this.unmodifiableSlotCount) {
            this.field_7761.subList(this.unmodifiableSlotCount, this.field_7761.size()).clear();
        }
        if(this.field_29206.size() > this.unmodifiableSlotCount) {
            this.field_29206.subList(this.unmodifiableSlotCount, this.field_29206.size()).clear();
        }

        this.addModifiableSlots();
    }

    public void updateSlotsPosition() {
        int slot = 0;

        for(int i = BACKPACK_INV_START; i < BACKPACK_INV_END; i++) {
            if(this.field_7761.get(i).getClass().equals(BackpackSlotItemHandler.class)) {
                this.field_7761.get(i).field_7873 = this.extendedScreenOffset + 8 + slot * 18;

                if(slot < this.wrapper.getSlotsInRow() - 1) {
                    slot++;
                } else {
                    slot = 0;
                }
            }
        }

        int modifiedOffset = this.extendedScreenOffset * 2;
        if(this.wrapper.isExtended()) {
            modifiedOffset += (18 * 2);
        }

        for(int i = UPGRADE_START; i < UPGRADE_END; i++) {
            if(this.field_7761.get(i).getClass().equals(UpgradeLockableSlotItemHandler.class)) {
                this.field_7761.get(i).field_7873 = 9 * 18 + modifiedOffset + 15;
            }
        }

        modifiedOffset = this.extendedScreenOffset;
        if(this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }

        slot = 0;

        for(int i = PLAYER_INV_START; i < PLAYER_HOT_END; i++) {
            if(this.field_7761.get(i).field_7871 instanceof class_1661) {
                this.field_7761.get(i).field_7873 = modifiedOffset + 8 + slot * 18;

                if(slot < 8) {
                    slot++;
                } else {
                    slot = 0;
                }
            }
        }
    }

    public void updateSlots() {
        this.extendedScreenOffset = 0;

        this.field_7764.clear();
        this.field_7761.clear();
        this.field_29206.clear();

        addSlots();
    }

    public void addUpgradeListeners() {
        for(Optional<? extends IUpgrade> upgrade : wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(iUpgrade -> iUpgrade.initializeContainers(this, this.wrapper));
        }
    }

    public void updateBackpackUpgradeSlots() {
        AtomicInteger nextSlot = new AtomicInteger();
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;

        for(int i = wrapper.getUpgrades().getSlots() - 1; i >= 0; i--) {
            if(!wrapper.getUpgrades().getStackInSlot(i).method_7960()) {
                if(i != 0 && lastOccupiedSlot == -1) {
                    lastOccupiedSlot = i;
                }
                if(!tabOpened && wrapper.getUpgradeManager().hasUpgradeInSlot(i)) {
                    tabOpened = wrapper.getUpgrades().getStackInSlot(i).method_57825(ModDataComponents.TAB_OPEN, false);
                }
            }
        }

        boolean finalTabOpened = tabOpened;
        int finalLastOccupiedSlot = lastOccupiedSlot;

        this.field_7761.stream().filter(slot -> slot instanceof UpgradeLockableSlotItemHandler).forEach(slot -> {
            UpgradeLockableSlotItemHandler upgradeSlot = (UpgradeLockableSlotItemHandler)slot;
            upgradeSlot.setHidden(false);
            int j = slot.method_34266();
            if(j > 0) {
                Optional<? extends IUpgrade> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(j - 1);
                if(upgrade != null && upgrade.isPresent()) {
                    nextSlot.addAndGet(upgrade.get().getTabSize().y() + 1);
                } else {
                    nextSlot.addAndGet(24 + 1);
                }
            }

            upgradeSlot.field_7872 = 15 + 18 + nextSlot.get();
            if(finalTabOpened) {
                if(upgradeSlot.method_34266() > finalLastOccupiedSlot) {
                    upgradeSlot.setHidden(true);
                }
            }

            upgradeSlot.setLocked(upgradeSlot.method_7677().method_7909() instanceof UpgradeItem);
        });
    }

    public void addBackpackUpgradeSlots(BackpackWrapper wrapper) {
        upgradeSlot.clear();

        int modifiedOffset = this.extendedScreenOffset * 2;
        if(this.wrapper.isExtended()) {
            modifiedOffset += (18 * 2);
        }

        int nextSlot = 0;
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;

        for(int i = wrapper.getUpgrades().getSlots() - 1; i >= 0; i--) {
            if(!wrapper.getUpgrades().getStackInSlot(i).method_7960()) {
                if(i != 0 && lastOccupiedSlot == -1) {
                    lastOccupiedSlot = i;
                }
                if(!tabOpened && wrapper.getUpgradeManager().hasUpgradeInSlot(i)) {
                    tabOpened = wrapper.getUpgrades().getStackInSlot(i).method_57825(ModDataComponents.TAB_OPEN, false);
                }
            }
        }

        for(int i = 0; i < wrapper.getUpgrades().getSlots(); i++) {

            if(i > 0) {
                Optional<? extends IUpgrade> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(i - 1);
                if(upgrade != null && upgrade.isPresent()) {
                    nextSlot += upgrade.get().getTabSize().y() + 1;
                } else {
                    nextSlot += 24 + 1;
                }
            }

            UpgradeLockableSlotItemHandler slot = new UpgradeLockableSlotItemHandler(this, wrapper.getUpgrades(), i, 9 * 18 + modifiedOffset + 15, 15 + 18 + nextSlot);
            if(tabOpened) {
                if(slot.method_34266() > lastOccupiedSlot) {
                    slot.setHidden(true);
                }
            }
            this.method_7621(slot);
        }
    }

    @Override
    protected class_1735 method_7621(class_1735 slot) {
        if(slot instanceof UpgradeLockableSlotItemHandler upgradeSlotItemHandler) {
            this.upgradeSlot.add(upgradeSlotItemHandler);
        }
        return super.method_7621(slot);
    }

    public void addBackpackToolSlots(BackpackWrapper wrapper) {
        for(int i = 0; i < wrapper.getTools().getSlots(); i++) {
            this.method_7621(new ToolSlotItemHandler(wrapper, i, -14, 18 + (i * 18)));
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if(this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }

        for(int y = 0; y < 3; y++) {
            for(int x = 0; x < 9; x++) {
                this.method_7621(new class_1735(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (this.wrapper.getRows() * 18 + 7 + 25) + y * 18));
            }
        }

        for(int x = 0; x < 9; x++) {
            this.method_7621(new class_1735(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
        }
    }

    public void addUpgradeSlots(BackpackWrapper wrapper) {
        for(Optional<UpgradeBase<?>> upgrade : wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(upgradeLoaded -> {
                int x = upgradeSlot.get(wrapper.getUpgradeManager().mappedUpgrades.inverse().get(upgrade)).field_7873 - 4;
                int y = upgradeSlot.get(wrapper.getUpgradeManager().mappedUpgrades.inverse().get(upgrade)).field_7872 - 4;
                if(upgradeLoaded.isTabOpened()) {
                    for(var slot : upgradeLoaded.getUpgradeSlots(this, wrapper, x, y)) {
                        this.method_7621(slot);
                    }
                }
                //Update result slot on client
                if(upgradeLoaded instanceof CraftingUpgrade) {
                    this.method_7623();
                }
            });
        }
    }

    @Override
    protected void method_30010(int pSlotId, int pButton, class_1713 pClickType, class_1657 pPlayer) {
        //Trash slot logic
        if(pSlotId >= 0 && pSlotId < this.field_7761.size() && this.field_7761.get(pSlotId) instanceof TrashSlot trashSlot) {
            if(!method_34255().method_7960() && trashSlot.method_7681() && pClickType == class_1713.field_7790) {
                trashSlot.method_7673(class_1799.field_8037.method_7972());
            }
        }
        if(pSlotId >= 0 && pSlotId < this.field_7761.size() && this.field_7761.get(pSlotId) instanceof FilterSlotItemHandler filterSlot) {
            if(method_34255().method_7960() && pClickType == class_1713.field_7790 && pButton == 0) { //Remove item from filter slot
                super.method_30010(pSlotId, pButton, pClickType, pPlayer);
            } else if(!method_34255().method_7960() && filterSlot.method_7680(method_34255())) { //Add item to filter slot
                if(!filterSlot.method_7681()) {
                    filterSlot.method_7673(method_34255().method_46651(1));
                }
            }
        } else {
            super.method_30010(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    protected void canCraft(class_1937 level, class_1657 player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.slotChangedCraftingGrid(craftingUpgrade, level, player));
    }

    @Override
    public void method_7609(class_1263 container) {
        super.method_7609(container);
        canCraft(inventory.field_7546.method_37908(), inventory.field_7546);
    }

    @Override
    public void method_34252() {
        super.method_34252();
        this.canCraft(inventory.field_7546.method_37908(), inventory.field_7546);
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if(this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent()) {
            return slot.field_7871 != this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get().resultSlots;
        }
        if(slot instanceof FilterSlotItemHandler) {
            return false;
        }
        return super.method_7613(stack, slot);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = method_7611(index);
        class_1799 result = class_1799.field_8037;
        if(slot != null && slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if(slot instanceof ResultSlotExt resultSlotExtNew) {
                return handleShiftCraft(this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get(), player, resultSlotExtNew);
            }
            if(slot instanceof CraftingSlot) {
                if(!method_7616(stack, BACKPACK_INV_START, PLAYER_HOT_END, false)) {
                    return class_1799.field_8037;
                }
            }
            if(index >= BACKPACK_INV_START && index < BACKPACK_INV_END) {
                if(!method_7616(stack, PLAYER_INV_START, PLAYER_HOT_END, true)) {
                    return class_1799.field_8037;
                }
            }
            if(index >= PLAYER_INV_START && index < PLAYER_HOT_END) {
                if(wrapper.showToolSlots() && ToolSlotItemHandler.isValid(stack)) {
                    if(!method_7616(stack, TOOL_START, TOOL_END, false)) {
                        if(!method_7616(stack, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                            return class_1799.field_8037;
                        }
                    }
                }

                if(!checkMemorySlots(stack)) {
                    if(!method_7616(stack, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                        return class_1799.field_8037;
                    }
                }
            }
            if(slot instanceof UpgradeSlotItemHandler<?> upgradeSlotItemHandler) {
                if(upgradeSlotItemHandler.shiftClickToBackpack()) {
                    if(!method_7616(stack, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                        if(!method_7616(stack, PLAYER_INV_START, PLAYER_HOT_END, true)) {
                            return class_1799.field_8037;
                        }
                    }
                } else {
                    if(!method_7616(stack, PLAYER_INV_START, PLAYER_HOT_END, true)) {
                        if(!method_7616(stack, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                            return class_1799.field_8037;
                        }
                    }
                }
            }
            if(slot instanceof ToolSlotItemHandler) {
                if(!method_7616(stack, PLAYER_INV_START, PLAYER_HOT_END, true)) {
                    return class_1799.field_8037;
                }
            }
            if(stack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7673(stack);
                //slot.setChanged();
            }
            if(stack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stack);
        }
        return result;
    }

    public boolean checkMemorySlots(class_1799 stack) {
        if(!wrapper.getMemorySlots().isEmpty()) {
            for(Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : wrapper.getMemorySlots()) {
                if(stack.method_7909() != memorizedStack.getSecond().getFirst().method_7909()) {
                    continue;
                }

                if(memorizedStack.getSecond().getSecond()) {
                    if(ItemStackUtils.isSameItemSameComponents(memorizedStack.getSecond().getFirst(), stack)) {
                        if(method_7616(stack, memorizedStack.getFirst(), memorizedStack.getFirst() + 1, false)) {
                            return stack.method_7960();
                        }
                    }
                } else {
                    if(class_1799.method_7984(memorizedStack.getSecond().getFirst(), stack)) {
                        if(method_7616(stack, memorizedStack.getFirst(), memorizedStack.getFirst() + 1, false)) {
                            return stack.method_7960();
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean applyRespectedSlotLogic = startIndex == BACKPACK_INV_START && endIndex == BACKPACK_INV_END;
        boolean flag = false;
        int i = startIndex;
        if(reverseDirection) {
            i = endIndex - 1;
        }

        if(stack.method_7946()) {
            while(!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                class_1735 slot = this.field_7761.get(i);
                class_1799 itemstack = slot.method_7677().method_7972();
                if(!itemstack.method_7960() && class_1799.method_31577(stack, itemstack)) {
                    int j = itemstack.method_7947() + stack.method_7947();
                    int k = slot.method_7676(itemstack);
                    if(j <= k) {
                        stack.method_7939(0);
                        itemstack.method_7939(j);
                        slot.method_7673(itemstack);
                        //slot.setChanged();
                        flag = true;
                    } else if(itemstack.method_7947() < k) {
                        stack.method_7934(k - itemstack.method_7947());
                        itemstack.method_7939(k);
                        slot.method_7673(itemstack);
                        //slot.setChanged();
                        flag = true;
                    }
                }

                if(reverseDirection) {
                    i--;
                } else {
                    i++;
                }
            }
        }

        if(!stack.method_7960()) {
            if(reverseDirection) {
                i = endIndex - 1;
            } else {
                i = startIndex;
            }

            while(reverseDirection ? i >= startIndex : i < endIndex) {
                class_1735 slot1 = this.field_7761.get(i);
                boolean accept = true;
                Optional<Pair<Integer, Pair<class_1799, Boolean>>> memorizedOptional = getWrapper().getMemorizedSlot(slot1.field_7874);
                boolean isUnsortable = getWrapper().getUnsortableSlots().contains(slot1.field_7874);
                if(memorizedOptional.isPresent()) {
                    class_1799 memorizedStack = memorizedOptional.get().getSecond().getFirst();
                    boolean matchComponents = memorizedOptional.get().getSecond().getSecond();
                    if(applyRespectedSlotLogic) {
                        accept = matchComponents ? ItemStackUtils.isSameItemSameComponents(memorizedStack, stack) : class_1799.method_7984(memorizedStack, stack);
                    }
                }
                if(isUnsortable) {
                    if(!memorizedOptional.isPresent() && accept) {
                        if(applyRespectedSlotLogic) {
                            accept = false;
                        }
                    }
                }

                class_1799 itemstack1 = slot1.method_7677();
                if(itemstack1.method_7960() && slot1.method_7680(stack) && accept) {
                    int l = slot1.method_7676(stack);
                    slot1.method_53512(stack.method_7971(Math.min(stack.method_7947(), l)));
                    slot1.method_7668();
                    flag = true;
                    break;
                }

                if(reverseDirection) {
                    i--;
                } else {
                    i++;
                }
            }
        }

        return flag;
    }

    public class_1799 handleShiftCraft(CraftingUpgrade upgrade, class_1657 player, ResultSlotExt resultSlot) {
        class_1799 outputCopy = class_1799.field_8037;
        class_9694 input = upgrade.craftSlots.method_59961();

        if(resultSlot != null && resultSlot.method_7681()) {
            upgrade.craftSlots.checkChanges = false;
            class_8786<class_3955> recipe = (class_8786<class_3955>)upgrade.resultSlots.method_7663();
            while(recipe != null && recipe.comp_1933().method_8115(input, player.method_37908())) {
                class_1799 recipeOutput = recipe.comp_1933().method_8116(input, player.method_37908().method_30349());
                if(recipeOutput.method_7960()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + recipe.comp_1932() + " - This is NOT a bug in Traveler's Backpack!");
                }
                outputCopy = recipeOutput.method_7972();

                recipeOutput.method_7982(player.method_37908(), player, 1);
                //EventHooks.firePlayerCraftingEvent(player, recipeOutput, upgrade.craftSlots);

                if(!player.method_37908().field_9236) {
                    if(upgrade.shiftClickToBackpack(upgrade.getDataHolderStack())) {
                        if(!checkMemorySlots(recipeOutput)) {
                            if(!method_7616(recipeOutput, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                                upgrade.craftSlots.checkChanges = true;
                                return class_1799.field_8037;
                            }
                        }
                    } else {
                        if(!method_7616(recipeOutput, PLAYER_INV_START, PLAYER_HOT_END, true)) {
                            if(!method_7616(recipeOutput, BACKPACK_INV_START, BACKPACK_INV_END, false)) {
                                upgrade.craftSlots.checkChanges = true;
                                return class_1799.field_8037;
                            }
                        }
                    }
                }

                resultSlot.field_7869 += outputCopy.method_7947();
                // Handles the actual work of removing the input items.
                resultSlot.method_7667(player, recipeOutput);
                resetStackedContents(input);
            }
            upgrade.craftSlots.checkChanges = true;
            slotChangedCraftingGrid(upgrade, player.method_37908(), player);
        }
        return outputCopy;
    }

    public void resetStackedContents(class_9694 input) {
        class_1662 contents = input.method_59988();
        contents.method_7409();
        for(class_1799 i : input.method_59989()) {
            if(!i.method_7960()) {
                contents.method_20478(i, 1);
            }
        }
    }

    public void slotChangedCraftingGrid(CraftingUpgrade upgrade, class_1937 world, class_1657 player) {
        if(!world.field_9236 && upgrade.craftSlots.checkChanges) {
            class_1799 itemstack = class_1799.field_8037;
            class_9694 input = upgrade.craftSlots.method_59961();

            class_8786<class_3955> oldRecipe = (class_8786<class_3955>)upgrade.resultSlots.method_7663();
            class_8786<class_3955> recipe = oldRecipe;

            if(TravelersBackpack.polymorphLoaded) {
                if(PolymorphCompat.shouldResetRecipe(recipe, this, upgrade.craftSlots, world, player)) {
                    recipe = null;
                }
            }

            if(recipe == null || !recipe.comp_1933().method_8115(input, world)) {
                if(TravelersBackpack.polymorphLoaded) {
                    recipe = PolymorphCompat.getPolymorphedRecipe(this, upgrade.craftSlots, world, player);
                } else {
                    recipe = world.method_8433().method_8132(class_3956.field_17545, input, world).orElse(null);
                }
            }

            if(recipe != null) itemstack = recipe.comp_1933().method_8116(input, world.method_30349());

            // Need to check if the output is empty, because if the recipe book is being used, the recipe will already be set.
            if(oldRecipe != recipe || upgrade.resultSlots.method_5438(0).method_7960()) {
                for(class_1657 user : getWrapper().getPlayersUsing().stream().filter(p -> p instanceof class_3222).toList()) {
                    PacketDistributor.sendToPlayer((class_3222)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                }
                //PacketDistributor.sendToPlayer((ServerPlayer) player, new ClientboundUpdateRecipePacket(recipe, itemstack)); //(SeverPlayer)player
                upgrade.resultSlots.method_5447(0, itemstack);
                upgrade.resultSlots.method_7662(recipe);
            } else if(recipe != null) {
                // https://github.com/Shadows-of-Fire/FastWorkbench/issues/72 - Some modded recipes may update the output and not mark themselves as special, moderately
                // annoying but... bleh
                if(recipe.comp_1933().method_8118() || !recipe.getClass().getName().startsWith("net.minecraft") && !class_1799.method_7973(itemstack, upgrade.resultSlots.method_5438(0))) {
                    for(class_1657 user : getWrapper().getPlayersUsing().stream().filter(p -> p instanceof class_3222).toList()) {
                        PacketDistributor.sendToPlayer((class_3222)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                    }
                    //PacketDistributor.sendToPlayer((ServerPlayer) player, new ClientboundUpdateRecipePacket(recipe, itemstack)); //(SeverPlayer)player
                    upgrade.resultSlots.method_5447(0, itemstack);
                    upgrade.resultSlots.method_7662(recipe);
                }
            }
        }
    }

    @Override
    public void method_7595(class_1657 player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.checkHandlerAndPlaySound(craftingUpgrade.crafting, player, craftingUpgrade.crafting.getSlots()));
        this.wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> this.clearSlotsAndPlaySound(inventory.field_7546, tanksUpgrade.getFluidSlotsHandler(), 4));
        this.wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).ifPresent(this::voidTrashSlot);
        shiftTools(this.wrapper.getTools());
        super.method_7595(player);
    }

    public void clearSlotsAndPlaySound(class_1657 player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for(int i = 0; i < size; i++) {
            boolean flag = clearSlot(player, handler, i);
            if(flag) playSound = true;
        }
        if(playSound) {
            playSound(player);
        }
    }

    public boolean clearSlot(class_1657 player, ItemStackHandler handler, int index) {
        if(!handler.getStackInSlot(index).method_7960()) {
            if(player == null) return false;
            if(!player.method_5805() || (player instanceof class_3222 serverPlayer && serverPlayer.method_14239())) {
                class_1799 stack = handler.getStackInSlot(index).method_7972();
                handler.setStackInSlot(index, class_1799.field_8037);
                player.method_7328(stack, false);
                return false;
            } else {
                class_1799 stack = handler.getStackInSlot(index);
                handler.setStackInSlot(index, class_1799.field_8037);
                player.method_31548().method_7398(stack);
                return true;
            }
        }
        return false;
    }

    public static void playSound(class_1657 player) {
        player.method_37908().method_8396(player, player.method_24515(), class_3417.field_15197, class_3419.field_15245, 1.0F, (1.0F + (player.method_37908().method_8409().method_43057() - player.method_37908().method_8409().method_43057()) * 0.2F) * 0.7F);
    }

    public void shiftTools(ItemStackHandler toolSlotsHandler) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for(int i = 0; i < toolSlotsHandler.getSlots(); i++) {
            if(foundEmptySlot) {
                if(!toolSlotsHandler.getStackInSlot(i).method_7960()) {
                    needsShifting = true;
                }
            }
            if(toolSlotsHandler.getStackInSlot(i).method_7960() && !foundEmptySlot) {
                foundEmptySlot = true;
            }
        }

        if(needsShifting) {
            class_2371<class_1799> tools = class_2371.method_10213(toolSlotsHandler.getSlots(), class_1799.field_8037);
            int j = 0;
            for(int i = 0; i < toolSlotsHandler.getSlots(); i++) {
                if(!toolSlotsHandler.getStackInSlot(i).method_7960()) {
                    tools.set(j, toolSlotsHandler.getStackInSlot(i));
                    j++;
                }
            }
            j = 0;
            for(int i = 0; i < toolSlotsHandler.getSlots(); i++) {
                if(!tools.isEmpty()) {
                    toolSlotsHandler.setStackInSlot(i, tools.get(j));
                    j++;
                }
            }
        }
    }

    public void voidTrashSlot(VoidUpgrade upgrade) {
        upgrade.voidTrashSlotStack();
    }

    //Remove forbidden items from handler, if saving enabled
    public static void checkHandlerAndPlaySound(ItemStackHandler handler, class_1657 player, int size) {
        boolean playSound = false;
        for(int i = 0; i < size; i++) {
            boolean flag = clearSlot(handler, player, i);
            if(flag) playSound = true;
        }
        if(playSound) {
            playSound(player);
        }
    }

    public static boolean clearSlot(ItemStackHandler handler, class_1657 player, int index) {
        if(!BackpackSlotItemHandler.isItemValid(handler.getStackInSlot(index))) {
            if(player == null) return false;
            if(!player.method_5805()) {
                class_1799 stack = handler.getStackInSlot(index).method_7972();
                handler.setStackInSlot(index, class_1799.field_8037);

                if(player instanceof class_3222 serverPlayer && !serverPlayer.method_14239()) {
                    player.method_7328(stack, false);
                }
                return false;
            } else {
                class_1799 stack = handler.getStackInSlot(index);
                handler.setStackInSlot(index, class_1799.field_8037);
                player.method_31548().method_7398(stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }
}