package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3914;

public class BackpackBlockEntityMenu extends BackpackBaseMenu {
    private final class_3914 access;
    private final class_2248 backpackBlock;
    private final int infniteAccessUser;

    public BackpackBlockEntityMenu(int windowID, class_1661 inventory, ModScreenHandlerTypes.BlockEntityScreenData data) {
        this(windowID, inventory, isInfiniteAccess(data), getBlockEntity(inventory, data));
    }

    public BackpackBlockEntityMenu(int windowID, class_1661 inventory, int entityId, BackpackWrapper wrapper) {
        super(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU, windowID, inventory, wrapper);
        this.access = class_3914.method_17392(player.method_37908(), getWrapper().getBackpackPos());
        this.backpackBlock = player.method_37908().method_8320(getWrapper().getBackpackPos()).method_26204();
        this.infniteAccessUser = entityId;
        this.wrapper.addUser(inventory.field_7546);
    }

    private static int isInfiniteAccess(ModScreenHandlerTypes.BlockEntityScreenData data) {
        return data.entityId();
    }

    private static BackpackWrapper getBlockEntity(class_1661 inventory, ModScreenHandlerTypes.BlockEntityScreenData data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");

        class_2338 pos = data.pos();
        class_2586 blockEntityAtPos = inventory.field_7546.method_37908().method_8321(pos);

        if(blockEntityAtPos instanceof BackpackBlockEntity backpackBlockEntity) {
            backpackBlockEntity.getWrapper().addUser(inventory.field_7546);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + blockEntityAtPos);
    }

    @Override
    public boolean method_7597(class_1657 player) { //stillValid
        return this.access.method_17396((level, blockPos) -> !level.method_8320(blockPos).method_27852(this.backpackBlock) ? false : player.method_5628() == this.infniteAccessUser || player.method_56093(blockPos, 4.0), true);
    }

    @Override
    public void method_7595(class_1657 player) {
        if(player.field_7512 instanceof BackpackBaseMenu && player.method_37908().field_9236) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.method_7595(player);
    }
}
