package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class BackpackItemMenu extends BackpackBaseMenu {
    public BackpackItemMenu(int windowID, class_1661 playerInventory, ModScreenHandlerTypes.ItemScreenData data) {
        this(windowID, playerInventory, createWrapper(playerInventory, data));
    }

    public BackpackItemMenu(int windowID, class_1661 playerInventory, BackpackWrapper wrapper) {
        super(ModScreenHandlerTypes.BACKPACK_MENU, windowID, playerInventory, wrapper);
        this.wrapper.addUser(playerInventory.field_7546);
    }

    private static BackpackWrapper createWrapper(class_1661 inventory, ModScreenHandlerTypes.ItemScreenData data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");

        int screenID = data.screenID();
        int entityId = data.entityID();

        if(screenID == Reference.WEARABLE_SCREEN_ID) {
            if(entityId != -1) {
                BackpackWrapper targetWrapper = ComponentUtils.getBackpackWrapper((class_1657)inventory.field_7546.method_37908().method_8469(entityId));
                targetWrapper.addUser(inventory.field_7546);
                return targetWrapper;
            }
            return ComponentUtils.getBackpackWrapper(inventory.field_7546);
        } else {
            class_1799 backpackStack = entityId == -1 ? inventory.field_7546.method_5998(class_1268.field_5808) : inventory.field_7547.get(entityId);
            return new BackpackWrapper(backpackStack, screenID, inventory.field_7546, inventory.field_7546.method_37908(), entityId);
        }
    }

    @Override
    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
        if(getWrapper().getScreenID() == Reference.ITEM_SCREEN_ID && clickType == class_1713.field_7791) {
            class_1799 stack = player.method_31548().method_5438(dragType);
            class_1799 currentItem = player.method_31548().method_7391();

            if(!currentItem.method_7960() && stack == currentItem) {
                return;
            }
        }
        super.method_7593(slotId, dragType, clickType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if(this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }

        for(int y = 0; y < 3; y++) {
            for(int x = 0; x < 9; x++) {
                if(x + y * 9 + 9 == currentItemIndex) {
                    this.method_7621(new DisabledSlot(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (this.wrapper.getRows() * 18 + 7 + 25) + y * 18));
                    this.disabledSlotIndex = this.field_7761.size() - 1;
                } else {
                    this.method_7621(new class_1735(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (this.wrapper.getRows() * 18 + 7 + 25) + y * 18));
                }
            }
        }

        for(int x = 0; x < 9; x++) {
            if(x == currentItemIndex && wrapper.getScreenID() == Reference.ITEM_SCREEN_ID) {
                this.method_7621(new DisabledSlot(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
                this.disabledSlotIndex = this.field_7761.size() - 1;
            } else {
                this.method_7621(new class_1735(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
            }
        }
    }

    @Override
    public void method_7595(class_1657 player) {
        if(player.field_7512 instanceof BackpackBaseMenu && player.method_37908().field_9236) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.method_7595(player);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        if(getWrapper().getBackpackOwner() != null) {
            return getWrapper().getBackpackOwner().method_5805() && ComponentUtils.isWearingBackpack(getWrapper().getBackpackOwner());
        }
        if(getWrapper().getScreenID() == Reference.ITEM_SCREEN_ID) {
            class_1799 backpackStack = getWrapper().getBackpackSlotIndex() == -1 ? player.method_5998(class_1268.field_5808) : inventory.field_7547.get(getWrapper().getBackpackSlotIndex());
            return backpackStack.method_7909() instanceof TravelersBackpackItem;
        }
        return true;
    }
}
