package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.world.inventory.*;
import java.util.Objects;

public class BackpackSettingsMenu extends AbstractBackpackMenu {
    //BackpackBlockEntity
    private class_3914 access;
    private class_2248 backpackBlock;

    public BackpackSettingsMenu(int windowID, class_1661 playerInventory, ModScreenHandlerTypes.SettingsScreenData data) {
        this(windowID, playerInventory, createWrapper(playerInventory, data));
    }

    public BackpackSettingsMenu(int windowID, class_1661 playerInventory, BackpackWrapper wrapper) {
        this(ModScreenHandlerTypes.BACKPACK_SETTINGS_MENU, windowID, playerInventory, wrapper);

        if(this.wrapper.getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
            this.access = class_3914.method_17392(player.method_37908(), getWrapper().getBackpackPos());
            this.backpackBlock = player.method_37908().method_8320(getWrapper().getBackpackPos()).method_26204();
            this.wrapper.addUser(inventory.field_7546);
        } else {
            this.wrapper.addUser(playerInventory.field_7546);
        }
    }

    public BackpackSettingsMenu(class_3917<?> type, int windowID, class_1661 inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void updateSlots() {
        this.field_7764.clear();
        this.field_7761.clear();
        this.field_29206.clear();

        this.addSlots();
    }

    public void addSlots() {
        //Storage Slots
        this.addBackpackStorageSlots(wrapper);
        this.BACKPACK_INV_END = this.field_7761.size();

        //Player Inventory
        this.PLAYER_INV_START = this.field_7761.size();
        this.addPlayerInventoryAndHotbar(inventory, getWrapper().getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.field_7761.size();
    }

    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if(this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }

        if(wrapper.getScreenID() == Reference.ITEM_SCREEN_ID) {
            for(int y = 0; y < 3; y++) {
                for(int x = 0; x < 9; x++) {
                    if(x + y * 9 + 9 == currentItemIndex) {
                        this.method_7621(new DisabledSlot(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (this.wrapper.getRows() * 18 + 7 + 25) + y * 18));
                        this.disabledSlotIndex = this.field_7761.size() - 1;
                    } else {
                        this.method_7621(new class_1735(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (this.wrapper.getRows() * 18 + 7 + 25) + y * 18));
                    }
                }
            }

            for(int x = 0; x < 9; x++) {
                if(x == currentItemIndex) {
                    this.method_7621(new DisabledSlot(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
                    this.disabledSlotIndex = this.field_7761.size() - 1;
                } else {
                    this.method_7621(new class_1735(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
                }
            }
        } else {
            for(int y = 0; y < 3; y++) {
                for(int x = 0; x < 9; x++) {
                    this.method_7621(new class_1735(inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, (18 + this.wrapper.getRows() * 18 + 14) + y * 18));
                }
            }
            for(int x = 0; x < 9; x++) {
                this.method_7621(new class_1735(inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
            }
        }
    }

    @Override
    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {

    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return false;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    @Override
    public void method_7595(class_1657 player) {
        if(!player.method_37908().field_9236) {
            if(getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
                class_2338 pos = getWrapper().getBackpackPos();
                if(pos != null && player.method_37908().method_8321(pos) instanceof BackpackBlockEntity backpackBlockEntity) {
                    backpackBlockEntity.removeSettingsUser();
                }
            }
        }
        if(player.field_7512 instanceof BackpackSettingsMenu && player.method_37908().field_9236) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.method_7595(player);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        if(getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
            return this.access.method_17396((level, blockPos) -> !level.method_8320(blockPos).method_27852(this.backpackBlock) ? false : player.method_56093(blockPos, 4.0), true);
        } else {
            if(getWrapper().getBackpackOwner() != null) {
                return getWrapper().getBackpackOwner().method_5805() && ComponentUtils.isWearingBackpack(getWrapper().getBackpackOwner());
            }
            return true;
        }
    }

    private static BackpackWrapper createWrapper(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        boolean isBlockEntity = data.isBlockEntity();
        if(isBlockEntity) {
            return getBlockEntity(inventory, data);
        } else {
            return getWrapper(inventory, data);
        }
    }

    private static BackpackWrapper getWrapper(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        //Read all data with correct order
        int screenID = data.screenId();
        class_2338 pos = data.pos(); //Not used here
        int index = data.index();
        class_1799 backpackStack = index == -1 ? inventory.field_7546.method_5998(class_1268.field_5808) : inventory.field_7547.get(index);
        if(screenID == Reference.WEARABLE_SCREEN_ID) {
            return ComponentUtils.getBackpackWrapper(inventory.field_7546);
        } else {
            return new BackpackWrapper(backpackStack, screenID, inventory.field_7546, inventory.field_7546.method_37908(), index);
        }
    }

    private static BackpackWrapper getBlockEntity(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        //Read data
        class_2338 pos = data.pos();
        class_2586 blockEntityAtPos = inventory.field_7546.method_37908().method_8321(pos);
        if(blockEntityAtPos instanceof BackpackBlockEntity backpackBlockEntity) {
            backpackBlockEntity.getWrapper().addUser(inventory.field_7546);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            backpackBlockEntity.setSettingsUser(inventory.field_7546);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + blockEntityAtPos);
    }
}