package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.handler.IItemHandlerModifiable;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_5537;

public class BackpackSlotItemHandler extends SlotItemHandler {
    public BackpackSlotItemHandler(ItemStackHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
    }

    public static boolean isItemValid(class_1799 stack) {
        if(TravelersBackpackConfig.isItemBlacklisted(stack)) return false;

        return !(stack.method_7909() instanceof TravelersBackpackItem) && !stack.method_31573(ModTags.BLACKLISTED_ITEMS) && (TravelersBackpackConfig.getConfig().backpackSettings.allowShulkerBoxes || stack.method_7909().method_31568());
    }

    @Override
    public void method_7668() {
        if(!method_7677().method_7909().method_31568() || method_7677().method_7909() instanceof class_5537) {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(method_34266(), method_7677()); //fix for EasyShulkerBoxes and BundleItem not calling onContentsChanged
        }
        super.method_7668();
    }

    @Override
    public void method_7667(class_1657 player, class_1799 stack) {
        method_7673(method_7677()); //Emi fix
        super.method_7667(player, stack);
    }

    //Fixes JEI
    @Override
    public boolean method_7680(class_1799 stack) {
        return getItemHandler().isItemValid(field_7874, stack);
    }

    @Override
    public boolean method_7674(class_1657 playerIn) {
        return true;
    }
}