package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class ContainerSorter {
    public static final int SORT_BACKPACK = 0;
    public static final int QUICK_STACK = 1;
    public static final int TRANSFER_TO_BACKPACK = 2;
    public static final int TRANSFER_TO_PLAYER = 3;

    public static void selectSort(BackpackWrapper backpackWrapper, class_1657 player, int button, boolean shiftPressed) {
        if(button == SORT_BACKPACK) {
            sortBackpack(backpackWrapper, player, backpackWrapper.getSortType(), shiftPressed);
        } else if(button == QUICK_STACK) {
            quickStackToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if(button == TRANSFER_TO_BACKPACK) {
            transferToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if(button == TRANSFER_TO_PLAYER) {
            transferToPlayer(backpackWrapper, player);
        }
    }

    public static void sortBackpack(BackpackWrapper backpackWrapper, class_1657 player, SortSelector.SortType type, boolean shiftPressed) {
        if(shiftPressed) {
            backpackWrapper.setNextSortType();
        } else {
            List<class_1799> stacks = new ArrayList<>();
            CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
            for(int i = 0; i < storage.getSlots(); i++) {
                addStackWithMerge(stacks, backpackWrapper.getUnsortableSlots().contains(i) ? class_1799.field_8037 : storage.getStackInSlot(i));
            }
            if(!stacks.isEmpty()) {
                stacks.sort(SortSelector.getSortTypeComparator(stacks, type));
            }
            if(stacks.isEmpty()) return;
            int j = 0;
            for(int i = 0; i < storage.getSlots(); i++) {
                if(backpackWrapper.getUnsortableSlots().contains(i)) continue;
                storage.setStackInSlot(i, j < stacks.size() ? stacks.get(j) : class_1799.field_8037);
                j++;
            }
        }
    }

    public static void quickStackToBackpackNoSort(BackpackWrapper backpackWrapper, class_1657 player, boolean shiftPressed) {
        InvWrapper playerStacks = new InvWrapper(player.method_31548());
        for(int i = shiftPressed ? 0 : 9; i < 36; ++i) {
            class_1799 playerStack = playerStacks.getStackInSlot(i);
            if(playerStack.method_7960() || (backpackWrapper.getScreenID() == Reference.ITEM_SCREEN_ID && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex())))
                continue;
            CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
            boolean hasExistingStack = IntStream.range(0, storage.getSlots()).mapToObj(storage::getStackInSlot).filter(existing -> !existing.method_7960()).anyMatch(existing -> existing.method_7909() == playerStack.method_7909());
            if(!hasExistingStack) continue;
            class_1799 ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
            for(int j = 0; j < storage.getSlots(); ++j) {
                ext = storage.insertItem(j, ext, false);
                if(ext.method_7960()) break;
            }
            if(!ext.method_7960()) {
                playerStacks.insertItem(i, ext, false);
            }
        }
    }

    public static void transferToBackpackNoSort(BackpackWrapper backpackWrapper, class_1657 player, boolean shiftPressed) {
        InvWrapper playerStacks = new InvWrapper(player.method_31548());
        //Run for Memory Slots
        if(!backpackWrapper.getMemorySlots().isEmpty()) {
            for(Pair<Integer, Pair<class_1799, Boolean>> pair : backpackWrapper.getMemorySlots()) {
                for(int i = shiftPressed ? 0 : 9; i < 36; ++i) {
                    class_1799 playerStack = playerStacks.getStackInSlot(i);
                    if(playerStack.method_7960() || (backpackWrapper.getScreenID() == Reference.ITEM_SCREEN_ID && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex())))
                        continue;
                    CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                    class_1799 extSimulate = playerStacks.extractItem(i, Integer.MAX_VALUE, true);
                    class_1799 ext = class_1799.field_8037; //playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    if(pair.getSecond().getSecond() ? ItemStackUtils.isSameItemSameTags(pair.getSecond().getFirst(), extSimulate) : class_1799.method_7984(pair.getSecond().getFirst(), extSimulate)) {
                        ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                        ext = wrapper.insertItem(pair.getFirst(), ext, false);
                        if(ext.method_7960()) continue;
                    }
                    if(!ext.method_7960()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
        }

        //Run for Normal Slots
        for(int i = shiftPressed ? 0 : 9; i < 36; ++i) {
            class_1799 playerStack = playerStacks.getStackInSlot(i);
            if(playerStack.method_7960() || (backpackWrapper.getScreenID() == Reference.ITEM_SCREEN_ID && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex())))
                continue;
            CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
            class_1799 ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
            for(int j = 0; j < wrapper.getSlots(); ++j) {
                ext = wrapper.insertItem(j, ext, false);
                if(ext.method_7960()) break;
            }
            if(!ext.method_7960()) {
                playerStacks.insertItem(i, ext, false);
            }
        }
    }

    public static void transferToPlayer(BackpackWrapper backpackWrapper, class_1657 player) {
        InvWrapper playerStacks = new InvWrapper(player.method_31548());
        CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
        for(int i = 0; i < wrapper.getSlots(); ++i) {
            class_1799 stack = wrapper.getStackInSlot(i);
            if(stack.method_7960()) continue;
            class_1799 ext = wrapper.extractItem(i, Integer.MAX_VALUE, false);
            for(int j = 9; j < 36; ++j) {
                ext = playerStacks.insertItem(j, ext, false);
                if(ext.method_7960()) break;
            }
            if(!ext.method_7960()) {
                wrapper.isTransferToPlayer = true;
                wrapper.insertItem(i, ext, false);
                wrapper.isTransferToPlayer = false;
            }
        }
    }

    private static void addStackWithMerge(List<class_1799> stacks, class_1799 newStack) {
        if(newStack.method_7960()) return;
        if(newStack.method_7946() && newStack.method_7947() != newStack.method_7914()) {
            for(int j = stacks.size() - 1; j >= 0; j--) {
                class_1799 oldStack = stacks.get(j);
                if(canMergeItems(newStack, oldStack)) {
                    combineStacks(newStack, oldStack);
                    if(oldStack.method_7960() || oldStack.method_7947() == 0) {
                        stacks.remove(j);
                    }
                }
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(class_1799 stack, class_1799 stack2) {
        if(stack.method_7914() >= stack.method_7947() + stack2.method_7947()) {
            stack.method_7933(stack2.method_7947());
            stack2.method_7939(0);
        }
        int maxInsertAmount = Math.min(stack.method_7914() - stack.method_7947(), stack2.method_7947());
        stack.method_7933(maxInsertAmount);
        stack2.method_7934(maxInsertAmount);
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        if(!stack1.method_7946() || !stack2.method_7946()) {
            return false;
        }
        if(stack1.method_7947() == stack2.method_7914() || stack2.method_7947() == stack2.method_7914()) {
            return false;
        }
        if(stack1.method_7909() != stack2.method_7909()) {
            return false;
        }
        if(stack1.method_7919() != stack2.method_7919()) {
            return false;
        }
        return class_1799.method_31577(stack1, stack2);
    }

    public static class CustomWrapper extends ItemStackHandler {
        public final BackpackWrapper wrapper;
        public final ItemStackHandler parent;
        public boolean isTransferToPlayer;

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent) {
            this(wrapper, parent, false);
        }

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent, boolean isTransferToPlayer) {
            this.wrapper = wrapper;
            this.parent = parent;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        @Override
        public void setStackInSlot(int slot, @NotNull class_1799 stack) {
            parent.setStackInSlot(slot, stack);
        }

        @Override
        public int getSlots() {
            return parent.getSlots();
        }

        @Override
        public @NotNull class_1799 getStackInSlot(int slot) {
            return parent.getStackInSlot(slot);
        }

        @Override
        public @NotNull class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
            if(wrapper.getMemorizedSlot(slot).isPresent()) {
                return wrapper.getMemorySlots().stream().noneMatch(pair -> {
                    if(pair.getSecond().getSecond()) {
                        return pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags(pair.getSecond().getFirst(), stack);
                    } else {
                        return pair.getFirst() == slot && class_1799.method_7984(pair.getSecond().getFirst(), stack);
                    }
                }) ? stack : parent.insertItem(slot, stack, simulate);
            }
            return wrapper.getUnsortableSlots().contains(slot) ? stack : parent.insertItem(slot, stack, simulate);
        }

        @Override
        public @NotNull class_1799 extractItem(int slot, int amount, boolean simulate) {
            return wrapper.getUnsortableSlots().contains(slot) ? class_1799.field_8037 : parent.extractItem(slot, amount, simulate);
        }

        @Override
        public int getSlotLimit(int slot) {
            return parent.getSlotLimit(slot);
        }

        @Override
        public boolean isItemValid(int slot, @NotNull class_1799 stack) {
            return parent.isItemValid(slot, stack);
        }
    }
}