package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public abstract class FilterSettingsBase {
    protected List<class_1799> filterItems;
    protected List<String> filterTags = new ArrayList<>();
    protected List<class_6862<class_1792>> tags = new ArrayList<>();
    protected List<Integer> filterSettings;
    protected ItemStackHandler storage;
    private final int slotLimit;

    public FilterSettingsBase(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings, int slotLimit) {
        this(storage, items, filterSettings, List.of(), slotLimit);
    }

    public FilterSettingsBase(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings, List<String> filterTags, int slotLimit) {
        this.filterItems = items;
        this.filterTags = filterTags;
        this.filterSettings = filterSettings;
        this.storage = storage;
        this.slotLimit = slotLimit;

        reloadItemTags();
    }

    public abstract boolean matchesFilter(@Nullable class_1657 player, class_1799 stack);

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean isTagFilter() {
        return false;
    }

    public boolean compareModId(class_1799 stack, class_1799 other) {
        return class_7923.field_41178.method_10221(stack.method_7909()).method_12836().equals(class_7923.field_41178.method_10221(other.method_7909()).method_12836());
    }

    public Stream<class_1799> streamStorageContents() {
        List<class_1799> arrayList = new ArrayList<>();
        for(int i = 0; i < storage.getSlots(); i++) {
            if(!storage.getStackInSlot(i).method_7960()) {
                arrayList.add(storage.getStackInSlot(i));
            }
        }
        return arrayList.stream();
    }

    public void reloadItemTags() {
        this.tags.clear();
        if(this.filterTags != null) {
            this.filterTags.forEach(string -> {
                class_6862<class_1792> tagKey = class_6862.method_40092(class_7924.field_41197, class_2960.method_60654(string));
                if(!tags.contains(tagKey)) {
                    tags.add(tagKey);
                }
            });
        }
    }

    public void updateFilter(@Nullable List<class_1799> items) {
        if(items == null) return;
        this.filterItems = items.stream().limit(this.slotLimit).filter(stack -> !stack.method_7960()).toList();
    }

    public void updateFilterTags(List<String> tags) {
        if(tags == null) return;
        this.filterTags = new ArrayList<>(tags);
        reloadItemTags();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }

    public List<class_1799> getFilterItems() {
        return this.filterItems;
    }

    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public List<String> getAddableTags() {
        List<String> addableTags = new ArrayList<>();
        class_1799 stack = class_1799.field_8037;
        if(filterItems != null && !filterItems.isEmpty()) {
            stack = filterItems.get(0);
        }
        if(!stack.method_7960()) {
            stack.method_40133().forEach(tag -> addableTags.add(tag.comp_327().toString()));
        }
        addableTags.removeAll(this.filterTags);
        return addableTags;
    }
}