package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface IUpgrade<T> {
    /**
     * Method to remove all additional things that upgrade might add
     */
    default void remove() {

    }

    /**
     * Called when the upgrade is removed from the backpack via the upgrade tab
     *
     * @param removedStack
     */
    default void onUpgradeRemoved(class_1799 removedStack) {

    }

    default void onUpgradeRemoved(class_1799 removedStack, @Nullable class_1657 player) {
        onUpgradeRemoved(removedStack);
    }

    @Environment(EnvType.CLIENT)
    WidgetBase createWidget(BackpackScreen screen, int x, int y);

    List<? extends class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y);

    default void initializeContainers(BackpackBaseMenu menu, BackpackWrapper wrapper) {

    }

    Point getTabSize();

    boolean isTabOpened();
}