package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ResultArrowElement {
    private final BackpackScreen backpackScreen;
    private final UpgradeWidgetBase<?> upgradeWidgetBase;
    private final WidgetElement arrowElement;

    public ResultArrowElement(BackpackScreen backpackScreen, UpgradeWidgetBase<?> upgradeWidgetBase, WidgetElement arrowElement) {
        this.backpackScreen = backpackScreen;
        this.upgradeWidgetBase = upgradeWidgetBase;
        this.arrowElement = arrowElement;
    }

    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if(upgradeWidgetBase.isTabOpened() && upgradeWidgetBase.getUpgrade() instanceof IMoveSelector selector) {
            if(selector.shiftClickToBackpack(upgradeWidgetBase.getUpgrade().getDataHolderStack())) {
                guiGraphics.method_25302(BackpackScreen.ICONS, upgradeWidgetBase.getPos().x() + arrowElement.pos().x(), upgradeWidgetBase.getPos().y() + arrowElement.pos().y(), 12, 55, arrowElement.size().x(), arrowElement.size().y());
            } else {
                guiGraphics.method_25302(BackpackScreen.ICONS, upgradeWidgetBase.getPos().x() + arrowElement.pos().x(), upgradeWidgetBase.getPos().y() + arrowElement.pos().y(), 0, 55, arrowElement.size().x(), arrowElement.size().y());
            }
        }
    }

    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(upgradeWidgetBase.isTabOpened() && isMouseOverShiftClickButton(mouseX, mouseY) && upgradeWidgetBase.getUpgrade() instanceof IMoveSelector selector) {
            if(selector.shiftClickToBackpack(upgradeWidgetBase.getUpgrade().getDataHolderStack())) {
                guiGraphics.method_51438(backpackScreen.getFont(), class_2561.method_43471("screen.travelersbackpack.crafting_to_backpack"), mouseX, mouseY);
            } else {
                guiGraphics.method_51438(backpackScreen.getFont(), class_2561.method_43471("screen.travelersbackpack.crafting_to_player"), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if(isMouseOverShiftClickButton(pMouseX, pMouseY)) {
            if(upgradeWidgetBase.isTabOpened() && upgradeWidgetBase.getUpgrade() instanceof IMoveSelector selector) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, upgradeWidgetBase.getUpgrade().getDataHolderSlot(), !selector.shiftClickToBackpack(upgradeWidgetBase.getUpgrade().getDataHolderStack()), ServerActions.SHIFT_CLICK_TO_BACKPACK);
                backpackScreen.playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public boolean isMouseOverShiftClickButton(double mouseX, double mouseY) {
        return upgradeWidgetBase.isWithinBounds(mouseX, mouseY, arrowElement);
    }
}