package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public abstract class UpgradeBase<T> implements IUpgrade<T> {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.TAB_OPEN, false);
    }

    public class_1799 getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if(isTabOpened()) {
            if(this instanceof IFilterSlots slots) {
                int x = this.openTabSize.x();
                if(slots.getSlotsInRow() > 3) {
                    x += (slots.getSlotsInRow() - 3) * 18;
                }
                return new Point(x, this.openTabSize.y() + (18 * slots.getRows()));
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void updateDataHolderUnchecked(Consumer<class_1799> updater) {
        class_1799 dataHolderStack = getDataHolderStack().method_7972();

        //TS fix prevent
        if(dataHolderStack.method_7960()) return;

        updater.accept(dataHolderStack);
        getUpgradeManager().getUpgradesHandler().setStackInSlot(getDataHolderSlot(), dataHolderStack);
    }

    public <D> void updateDataHolderUnchecked(class_9331<D> dataKey, D value) {
        class_1799 dataHolderStack = getDataHolderStack().method_7972();

        //TS fix prevent
        if(dataHolderStack.method_7960()) return;

        dataHolderStack.method_57379(dataKey, value);
        getUpgradeManager().getUpgradesHandler().setStackInSlot(getDataHolderSlot(), dataHolderStack);
    }

    public void setCooldown(int cooldown) {
        class_1799 dataHolderStack = getDataHolderStack().method_7972();
        dataHolderStack.method_57379(ModDataComponents.COOLDOWN, cooldown);
        getUpgradeManager().getUpgradesHandler().setStackInSlot(getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return getDataHolderStack().method_57825(ModDataComponents.COOLDOWN, 100);
    }

    public boolean hasCooldown() {
        return getDataHolderStack().method_57826(ModDataComponents.COOLDOWN);
    }
}