package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_8566;

public class CraftingContainerImproved implements class_8566 {
    private final CraftingUpgrade craftingUpgrade;
    public boolean checkChanges = true;
    public BackpackBaseMenu menu;

    public CraftingContainerImproved(BackpackBaseMenu menu, CraftingUpgrade craftingUpgrade) {
        this.menu = menu;
        this.craftingUpgrade = craftingUpgrade;
    }

    @Override
    public int method_5439() {
        return this.craftingUpgrade.crafting.getSlots();
    }

    public class_2371<class_1799> getStackList() {
        class_2371<class_1799> stacks = class_2371.method_10211();
        for(int i = 0; i < craftingUpgrade.crafting.getSlots(); i++) {
            stacks.add(i, method_5438(i));
        }
        return stacks;
    }

    @Override
    public boolean method_5442() {
        for(int i = 0; i < method_5439(); i++) {
            if(!craftingUpgrade.crafting.getStackInSlot(i).method_7960()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return slot >= this.method_5439() ? class_1799.field_8037 : this.craftingUpgrade.crafting.getStackInSlot(slot);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return InventoryHelper.takeItem(this.craftingUpgrade.crafting, slot);
    }

    public class_1799 removeItemShiftClick(int slot, int amount) {
        class_1799 stack = InventoryHelper.removeItemShiftClick(craftingUpgrade.crafting, slot, amount);
        if(checkChanges) {
            this.menu.method_7609(this);
        }
        return stack;
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = this.craftingUpgrade.crafting.extractItem(slot, amount, false);
        if(!stack.method_7960()) {
            if(checkChanges) {
                this.menu.method_7609(this);
            }
        }
        return stack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.craftingUpgrade.crafting.setStackInSlot(slot, stack);
        if(checkChanges) {
            this.menu.method_7609(this);
        }
    }

    @Override
    public void method_5431() {

    }

    @Override
    public boolean method_5443(class_1657 p_39340_) {
        return true;
    }

    @Override
    public void method_5448() {
        for(int i = 0; i < method_5439(); i++) {
            method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public int method_17397() {
        return 3;
    }

    @Override
    public int method_17398() {
        return 3;
    }

    @Override
    public List<class_1799> method_51305() {
        return List.copyOf(this.getStackList());
    }

    @Override
    public void method_7683(class_1662 contents) {
        for(int i = 0; i < method_5439(); i++) {
            contents.method_7404(method_5438(i));
        }
    }
}