package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.CraftingSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.upgrades.IMoveSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class CraftingUpgrade extends UpgradeBase<CraftingUpgrade> implements IMoveSelector {
    public ItemStackHandler crafting;
    public class_1731 resultSlots;
    public CraftingContainerImproved craftSlots;

    public CraftingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> craftingContents) {
        super(manager, dataHolderSlot, new Point(66, 112));
        this.crafting = createHandler(craftingContents);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new CraftingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public void initializeContainers(BackpackBaseMenu menu, BackpackWrapper wrapper) {
        //Crafting Container
        this.craftSlots = new CraftingContainerImproved(menu, this);
        this.resultSlots = new class_1731();
    }

    @Override
    public void onUpgradeRemoved(class_1799 removedStack, @Nullable class_1657 player) {
        if(removedStack.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            BackpackContainerContents contents = removedStack.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            ItemStackHandler tempHandler = new ItemStackHandler(contents.getItems());
            BackpackBaseMenu.checkHandlerAndPlaySound(tempHandler, player, tempHandler.getSlots());

            //Save
            removedStack.method_57379(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(9, tempHandler));
        }
    }


    @Override
    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        List<class_1735> slots = new ArrayList<>();

        menu.CRAFTING_GRID_START = menu.field_7761.size();
        menu.CRAFTING_RESULT = menu.field_7761.size() + 9;

        for(int i = 0; i < 3; i++) {
            for(int j = 0; j < 3; j++) {
                slots.add(new CraftingSlot(this.craftSlots, j + i * 3, x + 7 + j * 18, y + 23 + i * 18) {
                    @Override
                    public boolean method_7682() {
                        return isTabOpened();
                    }

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return isTabOpened();
                    }
                });
            }
        }

        slots.add(new ResultSlotExt(wrapper, menu.player, this.craftSlots, this.resultSlots, 0, x + 25, y + 89) {
            @Override
            public boolean method_7674(class_1657 player) {
                return isTabOpened();
            }

            @Override
            public boolean method_7682() {
                return isTabOpened();
            }

        });
        return slots;
    }

    public void setSlotChanged(class_1799 dataHolderStack, int index, class_1799 stack) {
        dataHolderStack.method_57367(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9), new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
    }

    private ItemStackHandler createHandler(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks) {
            @Override
            protected void onContentsChanged(int slot) {
                updateDataHolderUnchecked(dataHolderStack -> setSlotChanged(dataHolderStack, slot, getStackInSlot(slot)));
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }
}