package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class FeedingWidget extends FilterUpgradeWidgetBase<FeedingWidget, FeedingUpgrade> {
    public FeedingWidget(BackpackScreen screen, FeedingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.feeding_upgrade");

        FilterButton<FeedingWidget> whitelistButton = new FilterButton<>(this, upgrade.getFilter().get(FeedingFilterSettings.ALLOW_MODE), ButtonStates.ALLOW_FEEDING, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<FeedingWidget> hungerModeButton = new FilterButton<>(this, upgrade.getFilter().get(FeedingFilterSettings.HUNGER_MODE), ButtonStates.HUNGER_MODE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<FeedingWidget> ignoreEffectModeButton = new FilterButton<>(this, upgrade.getFilter().get(FeedingFilterSettings.IGNORE_EFFECT_MODE), ButtonStates.IGNORE_EFFECT_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));

        this.addFilterButton(whitelistButton);
        this.addFilterButton(hungerModeButton);
        this.addFilterButton(ignoreEffectModeButton);
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);

        if(isTabOpened()) {
            if(getFilterButton(ButtonStates.ALLOW_FEEDING).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), WHITELIST_TOOLTIPS.get(getFilterButton(ButtonStates.ALLOW_FEEDING).getCurrentState()), mouseX, mouseY);
            }
            if(getFilterButton(ButtonStates.HUNGER_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), HUNGER_MODE_TOOLTIPS.get(getFilterButton(ButtonStates.HUNGER_MODE).getCurrentState()), mouseX, mouseY);
            }
            if(getFilterButton(ButtonStates.IGNORE_EFFECT_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), IGNORE_MODE_TOOLTIPS.get(getFilterButton(ButtonStates.IGNORE_EFFECT_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }

    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_allow"),
            class_2561.method_43471("screen.travelersbackpack.filter_block"));

    private static final List<class_2561> HUNGER_MODE_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_always_eat"),
            class_2561.method_43471("screen.travelersbackpack.filter_half_nutrition"),
            class_2561.method_43471("screen.travelersbackpack.filter_full_nutrition"));

    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_block_bad_effects"),
            class_2561.method_43471("screen.travelersbackpack.filter_allow_bad_effects"));
}