package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class JukeboxWidget extends UpgradeWidgetBase<JukeboxUpgrade> {
    private final WidgetElement playButton = new WidgetElement(new Point(24, 22), new Point(18, 18));
    private final WidgetElement stopButton = new WidgetElement(new Point(42, 22), new Point(18, 18));

    public JukeboxWidget(BackpackScreen screen, JukeboxUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 103), "screen.travelersbackpack.jukebox_upgrade");
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);

        if(isTabOpened()) {
            if(isMouseOverPlayButton(mouseX, mouseY)) {
                guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + playButton.pos().x(), pos.y() + playButton.pos().y(), 24, 18, playButton.size().x(), playButton.size().y());
            }
            if(isMouseOverStopButton(mouseX, mouseY)) {
                guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + stopButton.pos().x(), pos.y() + stopButton.pos().y(), 24, 18, stopButton.size().x(), stopButton.size().y());
            }
        }
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);

        if(isTabOpened()) {
            if(this.upgrade.isPlayingRecord()) {
                guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + 6, pos.y() + 22, 24, 36, 18, 18);
            }
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(this.upgrade.getUpgradeManager().getWrapper().getScreenID() == Reference.WEARABLE_SCREEN_ID) {
            if(isMouseOverPlayButton(pMouseX, pMouseY) && isBackpackOwner()) {
                if(isTabOpened() && this.upgrade.canPlayRecord()) {
                    ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, this.dataHolderSlot, true, ServerActions.PLAY_RECORD);
                    playDiscToPlayer(screen.method_17577().getPlayerInventory().field_7546.method_5628(), getFromDisk(upgrade.diskHandler.getStackInSlot(0)));
                    this.screen.playUIClickSound();
                    return true;
                }
            }
        }

        if(isMouseOverStopButton(pMouseX, pMouseY) && isBackpackOwner()) {
            if(isTabOpened() && this.upgrade.isPlayingRecord()) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, this.dataHolderSlot, false, ServerActions.PLAY_RECORD);
                if(this.upgrade.getUpgradeManager().getWrapper().getScreenID() == Reference.WEARABLE_SCREEN_ID) {
                    stopDisc(getFromDisk(upgrade.diskHandler.getStackInSlot(0)));
                }
                this.screen.playUIClickSound();
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean isMouseOverPlayButton(double mouseX, double mouseY) {
        return isWithinBounds(mouseX, mouseY, this.playButton);
    }

    public boolean isMouseOverStopButton(double mouseX, double mouseY) {
        return isWithinBounds(mouseX, mouseY, this.stopButton);
    }

    @Nullable
    public class_9793 getFromDisk(class_1799 stack) {
        if(stack.method_57826(class_9334.field_52175)) {
            return class_9793.method_60753(screen.method_17577().getPlayerInventory().field_7546.method_56673(), stack).get().comp_349();
        }
        return null;
    }

    @Environment(EnvType.CLIENT)
    public void playDiscToPlayer(int entityId, @Nullable class_9793 jukeboxSong) {
        if(jukeboxSong == null) {
            return;
        }

        var level = class_310.method_1551().field_1687;
        if(level == null) {
            return;
        }

        var entity = level.method_8469(entityId);
        if(entity == null) {
            return;
        }

        //Minecraft.getInstance().getSoundManager().stop();
        class_310.method_1551().method_1483().method_22140(new MovingSound(entity, jukeboxSong.comp_2835().comp_349()));
        class_310.method_1551().field_1705.method_1732(jukeboxSong.comp_2836());
    }

    @Environment(EnvType.CLIENT)
    public void stopDisc(class_9793 jukeboxSong) {
        if(jukeboxSong == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4875(jukeboxSong.comp_2835().comp_349().method_14833(), class_3419.field_15254);
    }

    public static class MovingSound extends class_1101 {

        private final class_1297 entity;

        public MovingSound(class_1297 entityIn, class_3414 soundIn) {
            super(soundIn, class_3419.field_15254, entityIn.method_37908().method_8409());
            this.entity = entityIn;
            this.field_5446 = false;
            this.field_5451 = 0;
            this.field_5442 = 1.0F;
        }

        @Override
        public void method_16896() {
            if(this.entity instanceof class_1657 player) {
                if(!ComponentUtils.isWearingBackpack(player) || !shouldStopPlaying(player)) {
                    this.method_24876();
                }
            }
            if(!this.entity.method_5805()) {
                this.method_24876();
            } else {
                this.field_5439 = (float)this.entity.method_23317();
                this.field_5450 = (float)this.entity.method_23318();
                this.field_5449 = (float)this.entity.method_23321();
            }
        }

        public boolean shouldStopPlaying(class_1657 player) {
            return ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY).getUpgradeManager().getUpgrade(JukeboxUpgrade.class).isPresent();
        }
    }
}
