package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.world.item.*;

import java.util.concurrent.atomic.AtomicBoolean;

public class TankActions {
    public static void fillTank(class_3222 player, boolean leftTank) {
        if(player.field_7512 instanceof BackpackBaseMenu menu) {
            BackpackWrapper wrapper = menu.getWrapper();
            FluidTank tank = leftTank ? wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getLeftTank() : wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getRightTank();
            class_1799 carried = menu.method_34255();
            AtomicBoolean handled = new AtomicBoolean(false);
            FluidUtil.getFluidStorageAtCursor(player, menu).ifPresent(fluidStorage -> {
                if(FluidUtil.hasFluid(fluidStorage) && carried.method_7947() == 1) {
                    class_3414 fluidSound = tank.isEmpty() ? class_3417.field_14834 : FluidTypeHelper.getSound(tank.getFluid().fluidVariant(), FluidTypeHelper.BUCKET_EMPTY);

                    long result = FluidUtil.tryEmptyContainerAtCursor(tank, wrapper.getBackpackTankCapacity(), fluidStorage, true);
                    if(result > 0) {
                        //Play client only sound for item
                        //if(wrapper.getScreenID() == Reference.ITEM_SCREEN_ID) {
                        InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, FluidTypeHelper.BUCKET_EMPTY);
                        //}
                        handled.set(true);
                    }
                } else if(!handled.get() && fluidStorage.supportsInsertion()) {
                    class_1799 carriedCopy = carried.method_7972();
                    int count = carriedCopy.method_7947();
                    carriedCopy.method_7939(count - 1);

                    //Fluid sound
                    class_3414 fluidSound = tank.isEmpty() ? class_3417.field_15126 : FluidTypeHelper.getSound(tank.getFluid().fluidVariant(), FluidTypeHelper.BUCKET_FILL);

                    if(carried.method_7909() instanceof class_1755) {
                        class_1792 fullBucket = tank.getFluid().fluidVariant().getFluid().method_15774();
                        long result = FluidUtil.tryFillBucketAtCursor(tank, wrapper.getBackpackTankCapacity(), fluidStorage, true);
                        if(result > 0) {
                            if(carriedCopy.method_7947() > 0) {
                                player.method_31548().method_7398(fullBucket.method_7854());
                                menu.method_34254(carriedCopy);
                            } else {
                                menu.method_34254(fullBucket.method_7854());
                            }
                            //Play client only sound for item
                            //if(wrapper.getScreenID() == Reference.ITEM_SCREEN_ID) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, FluidTypeHelper.BUCKET_FILL);
                            //}
                            handled.set(true);
                        }
                    } else if(!handled.get() && carried.method_7909() == class_1802.field_8469) {
                        class_1799 newCarried = tryFillPotion(carried, tank, player, true);
                        if(!newCarried.method_7960()) {
                            class_1799 result = tryFillPotion(carried, tank, player, false);
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), class_3417.field_14978, false);
                            menu.method_34254(result);
                            handled.set(true);
                        }
                    } else if(!handled.get() && carried.method_7947() == 1) {
                        long result = FluidUtil.tryFillContainerAtCursor(tank, wrapper.getBackpackTankCapacity(), fluidStorage, true);
                        if(result > 0) {
                            //Play client only sound for item
                            //if(wrapper.getScreenID() == Reference.ITEM_SCREEN_ID) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, FluidTypeHelper.BUCKET_FILL);
                            //}
                            handled.set(true);
                        }
                    }
                }
            });
            if(!handled.get() && carried.method_7909() instanceof class_1812 && carried.method_7909() != class_1802.field_8469) {
                if(carried.method_7947() == 1) {
                    int potionType = 0;
                    if(carried.method_7909() == class_1802.field_8436) potionType = 1;
                    if(carried.method_7909() == class_1802.field_8150) potionType = 2;
                    if(tryEmptyPotion(carried, tank, potionType)) {
                        InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), class_3417.field_14978, true);
                        menu.method_34254(potionType != 0 ? class_1799.field_8037.method_7972() : new class_1799(class_1802.field_8469));
                    }
                }
            }
        }
    }

    public static boolean tryEmptyPotion(class_1799 carried, FluidTank tank, int potionType) {
        long amount = FluidConstants.BOTTLE;
        //FluidVariantWrapper fluidStack = new FluidVariantWrapper(FluidVariant.of(ModFluids.POTION_STILL), amount);
        FluidVariant potionVariant = FluidStackHelper.setPotionFluidVariant(carried, potionType);
        FluidVariantWrapper potionVariantWrapper = new FluidVariantWrapper(potionVariant, amount);
        if(tank.isEmpty() || (potionVariantWrapper.fluidVariant().isOf(tank.getFluid().fluidVariant().getFluid())) && potionVariantWrapper.fluidVariant().componentsMatch(tank.getFluid().fluidVariant().getComponents())) {
            if(tank.getFluidAmount() + amount <= tank.getCapacity()) {
                tank.fill(potionVariantWrapper, false);
                return true;
            }
        }
        return false;
    }

    public static class_1799 tryFillPotion(class_1799 carried, FluidTank tank, class_3222 player, boolean simulate) {
        if(tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL && tank.getFluidAmount() >= FluidConstants.BOTTLE) {
            class_1799 filledPotion = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid().fluidVariant());
            if(simulate) {
                return filledPotion; //Return for simulate to check if it's possible to fill the bottle
            }
            class_1799 carriedCopy = carried.method_7972();
            int count = carriedCopy.method_7947();
            carriedCopy.method_7939(count - 1);
            tank.drain(FluidConstants.BOTTLE, false);
            if(carriedCopy.method_7947() > 0) {
                player.method_31548().method_7398(filledPotion);
                return carriedCopy;
            } else {
                return filledPotion;
            }
        }
        return class_1799.field_8037;
    }
}
