package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

public class TankWidget extends UpgradeWidgetBase<TanksUpgrade> {
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = upgrade.leftTankPos;
        this.rightTankPos = upgrade.rightTankPos;
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);

        if(inTank(this.leftTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(screen.getFont(), getTankTooltip(this.upgrade.leftTank), mouseX, mouseY);
        }

        if(inTank(this.rightTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(screen.getFont(), getTankTooltip(this.upgrade.rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int extendedOffset = 0;
        int rows = upgrade.getUpgradeManager().getWrapper().getRows();
        y += 10;
        RenderHelper.renderScreenTank(guiGraphics, this.upgrade.leftTank, x + 8, y + 8, 0, (screen.isScrollable ? screen.visibleRows : rows) * 18 - 2, 16);
        renderTank(guiGraphics, rows, x + 7, y);
        if(upgrade.getUpgradeManager().getWrapper().isExtended()) extendedOffset = 36;
        RenderHelper.renderScreenTank(guiGraphics, this.upgrade.rightTank, x + 196 + extendedOffset, y + 8, 0, (screen.isScrollable ? screen.visibleRows : rows) * 18 - 2, 16);
        renderTank(guiGraphics, rows, x + 195 + extendedOffset, y);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(inTank(this.leftTankPos, (int)pMouseX, (int)pMouseY)) {
            if(isValid(screen.method_17577().method_34255())) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.FILL_TANK, true);
                return true;
            }
        }
        if(inTank(this.rightTankPos, (int)pMouseX, (int)pMouseY)) {
            if(isValid(screen.method_17577().method_34255())) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.FILL_TANK, false);
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean isValid(class_1799 stack) {
        return FluidUtil.hasFluidStorageConstant(stack) || stack.method_7909() instanceof class_1812;
        //return true;
        //return FluidUtil.getFluidHandler(stack).isPresent() || stack.getItem() instanceof PotionItem || stack.getItem() == Items.GLASS_BOTTLE;
    }

    public void renderTank(class_332 guiGraphics, int rows, int x, int y) {
        //Top segment
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7, 0, 95, 18, 18);

        //Middle segment
        for(int i = 1; i <= (screen.isScrollable ? screen.visibleRows : rows) - 2; i++) {
            guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + (18 * i), 0, 113, 18, 18);
        }

        //Bottom segment
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + (18 * ((screen.isScrollable ? screen.visibleRows : rows) - 1)), 0, 131, 18, 18);
    }

    @Environment(EnvType.CLIENT)
    public List<class_2561> getTankTooltip(FluidTank tank) {
        FluidVariantWrapper fluidStack = tank.getFluid();
        List<class_2561> tankTips = new ArrayList<>();
        String fluidName = !fluidStack.isEmpty() ? FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant()).getString() : class_1074.method_4662("screen.travelersbackpack.none");
        String fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : class_1074.method_4662("screen.travelersbackpack.empty");

        if(!fluidStack.isEmpty()) {
            if(fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651) != null && fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).isPresent()) {
                float durationFactor = 1.0F;
                if(fluidStack.fluidVariant().getComponentMap().method_57832(class_9334.field_49628)) {
                    if(fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49628).get().method_57461().method_10545("PotionType")) {
                        int potionType = fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49628).get().method_57461().method_10550("PotionType");
                        if(potionType == 1) {
                            tankTips.add(class_2561.method_43471("item.minecraft.splash_potion"));
                        }
                        if(potionType == 2) {
                            tankTips.add(class_2561.method_43471("item.minecraft.lingering_potion"));
                            durationFactor = 0.25F;
                        }

                    }
                }
                fluidName = null;
                class_1844 contents = fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).get();
                if(class_310.method_1551().field_1687 != null) {
                    contents.method_47372(tankTips::add, durationFactor, class_310.method_1551().field_1687.method_54719().method_54748());
                }
            }
        }

        if(fluidName != null) tankTips.add(class_2561.method_43470(fluidName));
        tankTips.add(class_2561.method_43470(fluidAmount));

        return tankTips;
    }

    public boolean inTank(Point tankPos, int mouseX, int mouseY) {
        return screen.getGuiLeft() + tankPos.x() <= mouseX && mouseX <= tankPos.x() + this.tankWidth + screen.getGuiLeft() && tankPos.y() + screen.getGuiTop() <= mouseY && mouseY <= tankPos.y() + this.tankHeight + screen.getGuiTop();
    }
}