package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.SlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_2487;
import java.util.ArrayList;
import java.util.List;

public class TanksUpgrade extends UpgradeBase<TanksUpgrade> {
    private final ItemStackHandler fluidSlotsHandler = createTemporaryHandler();
    protected final FluidTank leftTank = createFluidHandler(1000);
    protected final FluidTank rightTank = createFluidHandler(1000);
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TanksUpgrade(UpgradeManager manager, int dataHolderSlot, Fluids fluids) {
        super(manager, dataHolderSlot, new Point(51, 72));
        this.setTanksCapacity();
        this.setFluids(fluids);

        this.leftTankPos = new Point(7, 15);
        this.rightTankPos = new Point(195 + (manager.getWrapper().isExtended() ? 36 : 0), 15);

        //Update Render data
        getUpgradeManager().getWrapper().setRenderInfo(writeToRenderData());
    }

    public FluidTank getLeftTank() {
        return leftTank;
    }

    public FluidTank getRightTank() {
        return rightTank;
    }

    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlotsHandler;
    }

    public void setTanksCapacity() {
        this.leftTank.setCapacity(getUpgradeManager().getWrapper().getBackpackTankCapacity());
        this.rightTank.setCapacity(getUpgradeManager().getWrapper().getBackpackTankCapacity());
    }

    public void setFluids(Fluids tanks) {
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void syncClients(class_1799 backpack) {
        int slot = getDataHolderSlot();
        BackpackContainerContents contents = backpack.method_57824(ModDataComponents.UPGRADES);
        if(contents == null) return;
        if(slot >= contents.getItems().size()) return;
        class_1799 stack = contents.getItems().get(slot);
        setFluids(stack.method_57825(ModDataComponents.FLUIDS, Fluids.empty()));
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity) {
            @Override
            protected void onContentsChanged() {
                updateDataHolderUnchecked(ModDataComponents.FLUIDS, new Fluids(leftTank.getFluid(), rightTank.getFluid()));

                //Update Render data
                getUpgradeManager().getWrapper().setRenderInfo(writeToRenderData());

                //Update backpack attachment data on clients
                getUpgradeManager().getWrapper().sendDataToClients(ModDataComponents.RENDER_INFO, ModDataComponents.UPGRADES);
            }
        };
    }

    public class_2487 writeToRenderData() {
        class_2487 tag = new class_2487();
        if(getUpgradeManager().getWrapper().getRegistriesAccess() != null) {
            tag.method_10566("LeftTank", leftTank.getFluid().saveOptional(getUpgradeManager().getWrapper().getRegistriesAccess()));
            tag.method_10566("RightTank", rightTank.getFluid().saveOptional(getUpgradeManager().getWrapper().getRegistriesAccess()));
        }
        tag.method_10544("Capacity", leftTank.getCapacity());
        return tag;
    }

    @Override
    public void remove() {
        getUpgradeManager().getWrapper().removeRenderInfo();
    }

    @Override
    @Environment(EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new TankWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<SlotItemHandler> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        List<SlotItemHandler> slots = new ArrayList<>();
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, getFluidSlotsHandler(), 0, x + 7, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, getFluidSlotsHandler(), 1, x + 7, y + 49));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, getFluidSlotsHandler(), 2, x + 28, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, getFluidSlotsHandler(), 3, x + 28, y + 49));
        return slots;
    }

    public ItemStackHandler createTemporaryHandler() {
        return new ItemStackHandler(4) {
            /*@Override
            protected void onContentsChanged(int slot) {
                if((slot == 0 || slot == 1) && !getStackInSlot(0).isEmpty()) {
                    InventoryActions.transferContainerTank(TanksUpgrade.this, getLeftTank(), 0);
                }
                if((slot == 2 || slot == 3) && !getStackInSlot(2).isEmpty()) {
                    InventoryActions.transferContainerTank(TanksUpgrade.this, getRightTank(), 2);
                }
            }*/

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                Storage<FluidVariant> storage = ContainerItemContext.withConstant(stack).find(FluidStorage.ITEM);
                if(slot == 1 || slot == 3) {
                    return false;
                }
                if(stack.method_7909() instanceof class_1812 || stack.method_7909() == class_1802.field_8469 || stack.method_7909() == class_1802.field_8103) {
                    return true;
                }
                return storage != null;
            }
        };
    }
}
