package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;

public class VoidFilterSettings extends FilterSettingsBase {
    //Button Types
    public static final int ALLOW_MODE = 0;
    public static final int OBJECT_CATEGORY = 1;
    public static final int IGNORE_MODE = 2;

    //Options
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int MATCH_CONTENTS = 2;

    public static final int ITEM = 0;
    public static final int MOD_ID = 1;
    public static final int TAG_ID = 2;

    public static final int MATCH_COMPONENTS = 0;
    public static final int IGNORE_COMPONENTS = 1;

    public VoidFilterSettings(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings, List<String> filterTags) {
        super(storage, items, filterSettings, filterTags, TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount);
    }

    @Override
    public boolean matchesFilter(@Nullable class_1657 player, class_1799 stack) {
        if(filterSettings.get(ALLOW_MODE) == ALLOW) {
            if(isTagFilter()) {
                for(class_6862<class_1792> tag : this.tags) {
                    if(stack.method_31573(tag)) {
                        return true;
                    }
                }
                return false;
            }
            return this.filterItems.stream().anyMatch(filterStack -> compare(filterStack, stack));
        }
        if(filterSettings.get(ALLOW_MODE) == BLOCK) {
            if(isTagFilter()) {
                for(class_6862<class_1792> tag : this.tags) {
                    if(stack.method_31573(tag)) {
                        return false;
                    }
                }
                return true;
            }
            return this.filterItems.stream().noneMatch(filterStack -> compare(filterStack, stack));
        }
        if(filterSettings.get(ALLOW_MODE) == MATCH_CONTENTS) {
            return streamStorageContents().anyMatch(filterStack -> compare(filterStack, stack));
        }
        return false;
    }

    @Override
    public boolean isTagFilter() {
        return filterSettings.get(OBJECT_CATEGORY) == TAG_ID;
    }

    public boolean compare(class_1799 stack, class_1799 other) {
        if(filterSettings.get(OBJECT_CATEGORY) == ITEM) {
            return compareItemStack(stack, other);
        } else {
            return compareModId(stack, other);
        }
    }

    public boolean compareItemStack(class_1799 stack, class_1799 other) {
        if(filterSettings.get(IGNORE_MODE) == IGNORE_COMPONENTS) {
            return class_1799.method_7984(stack, other);
        } else {
            return class_1799.method_31577(stack, other);
        }
    }

    @Override
    public void updateFilter(@Nullable List<class_1799> items) {
        if(items == null) return;
        super.updateFilter(items.stream().skip(1).toList());
    }
}