package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import java.util.List;

public class VoidUpgrade extends FilterUpgradeBase<VoidUpgrade, VoidFilterSettings> implements IEnable {
    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49),
                TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount,
                TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.slotsInRow, filter, filterTags);
    }

    @Override
    public List<Integer> getFilter() {
        return getDataHolderStack().method_57825(ModDataComponents.FILTER_SETTINGS, List.of(0, 0, 1));
    }

    @Override
    public VoidFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().skip(1).limit(getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), getFilter(), filterTags);
    }

    public boolean canVoid(class_1799 stack) {
        return getFilterSettings().matchesFilter(null, stack) && isEnabled(this);
    }

    @Override
    public class_1799 getFirstFilterStack() {
        return this.filter.getStackInSlot(1);
    }

    public class_1799 getTrashSlotStack() {
        return this.filter.getStackInSlot(0);
    }

    public void voidTrashSlotStack() {
        this.filter.setStackInSlot(0, class_1799.field_8037.method_7972());
    }

    @Override
    @Environment(EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        List<class_1735> slots = super.getUpgradeSlots(menu, wrapper, x, y);
        if(!isTagSelector()) {
            slots.replaceAll(slot -> {
                if(slot.field_7873 == x + 7 && slot.field_7872 == y + 44) {
                    return new TrashSlot(this, this.filter, 0, x + 7, y + 44, 0);
                }
                return slot;
            });
        } else {
            slots.clear();
            slots.add(new TrashSlot(this, this.filter, 0, x + 7, y + 44, 0) {
                @Override
                public boolean method_7682() {
                    return false;
                }

                @Override
                public boolean method_7680(class_1799 pStack) {
                    return false;
                }
            });
            slots.add(new FilterSlotItemHandler(this, this.filter, 1, x + 64, y + 23, 2));
        }
        return slots;
    }

    @Override
    protected FilterHandler createFilter(class_2371<class_1799> stacks, int size) {
        return new FilterHandler(stacks, size) {
            @Override
            protected void onContentsChanged(int slot) {
                updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(size, filter));

                getFilterSettings().updateFilter(getDataHolderStack().method_57824(ModDataComponents.BACKPACK_CONTAINER).getItems());
                getFilterSettings().updateFilterTags(getDataHolderStack().method_57824(ModDataComponents.FILTER_TAGS));
                changeListeners.forEach(Runnable::run);
            }

            @Override
            public int getSlotLimit(int slot) {
                if(slot == 0) {
                    return 64;
                }
                return 1;
            }
        };
    }
}