package com.tiviacz.travelersbackpack.item;

import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.List;

public class HoseItem extends class_1792 {
    public HoseItem(class_1793 properties) {
        //First int is always mode, second int is always tank
        super(properties.method_57349(ModDataComponents.HOSE_MODES, List.of(1, 1)));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        if(getHoseMode(stack) == DRINK_MODE) {
            return class_1839.field_8946;
        }
        return class_1839.field_8952;
    }

    @Override
    public int method_7881(class_1799 pStack, class_1309 pEntity) {
        return 24;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if(ComponentUtils.isWearingBackpack(player) && hand == class_1268.field_5808) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY);
            if(!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return class_1271.method_22430(stack);
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());

            if(getHoseMode(stack) == SUCK_MODE) {
                //Pick fluid from block
                class_3965 result = method_7872(level, player, class_3959.class_242.field_1345);
                class_2338 blockpos = result.method_17777();
                class_2350 direction1 = result.method_17780();
                class_2338 blockpos1 = blockpos.method_10093(result.method_17780());

                if(level.method_8505(player, blockpos) && player.method_7343(blockpos1, direction1, stack)) {
                    class_2680 blockstate1 = level.method_8320(blockpos);
                    if(blockstate1.method_26204() instanceof class_2263 pickup) {
                        class_3611 fluid = blockstate1.method_26227().method_15772();
                        if(fluid != class_3612.field_15906) {
                            FluidVariantWrapper fluidStack = new FluidVariantWrapper(FluidVariant.of(fluid), FluidConstants.BUCKET);
                            long tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                            boolean canFill = tank.isEmpty() || FluidUtil.isSameVariant(tank.getFluid().fluidVariant(), fluidStack.fluidVariant());
                            if(canFill && (fluidStack.getAmount() + tankAmount <= tank.getCapacity())) {
                                class_1799 actualFluid = pickup.method_9700(player, level, blockpos, blockstate1);
                                if(!actualFluid.method_7960()) {
                                    level.method_8396(player, result.method_17777(), FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_FILL) == null ? (fluid.method_15791(class_3486.field_15518) ? class_3417.field_15202 : class_3417.field_15126) : FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_FILL), class_3419.field_15245, 1.0F, 1.0F);
                                    tank.fill(new FluidVariantWrapper(FluidVariant.of(fluid), FluidConstants.BUCKET), false);
                                    triggerAdvancement(player, ActionTypeTrigger.HOSE_SUCK);
                                    return class_1271.method_22427(stack);
                                }
                            }
                        }
                    }
                }
            }

            if(getHoseMode(stack) == SPILL_MODE) {
                //Try to splash potion in the world
                if(tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL) {
                    if(tank.getFluid().fluidVariant().getComponentMap().method_57830(class_9334.field_49628, class_9279.field_49302).method_57450("PotionType")) {
                        int potionType = tank.getFluid().fluidVariant().getComponentMap().method_57829(class_9334.field_49628).method_57461().method_10550("PotionType");
                        if(potionType == 1) {
                            if(tank.getFluidAmount() >= FluidConstants.BOTTLE) {
                                class_1799 potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid().fluidVariant());
                                long drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                                tank.drain(drainAmount, false);
                                triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL_POTION);
                                return class_1271.method_22427(stack);
                            }
                        } else if(potionType == 2) {
                            if(tank.getFluidAmount() >= FluidConstants.BOTTLE) {
                                class_1799 potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid().fluidVariant());
                                long drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                                tank.drain(drainAmount, false);
                                triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL_POTION);
                                return class_1271.method_22427(stack);
                            }
                        }
                    }
                }
            }

            if(getHoseMode(stack) == DRINK_MODE) {
                if(!tank.isEmpty()) {
                    if(EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, player)) {
                        player.method_6019(hand);
                        return class_1271.method_22427(stack);
                    }
                }
            }
        }
        return class_1271.method_22430(stack);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 direction = context.method_8038(); //#TODO add compound initialization
        class_1799 stack = player.method_5998(context.method_20287());
        if(ComponentUtils.isWearingBackpack(player) && context.method_20287() == class_1268.field_5808) {
            Storage<FluidVariant> fluidVariantStorage = null;
            if(!level.field_9236) {
                fluidVariantStorage = FluidStorage.SIDED.find(level, pos, direction);
            }
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY);
            if(!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return class_1269.field_5811;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());

            if(getHoseMode(stack) == SUCK_MODE) {
                //Transfer fluid from fluid handler
                if(fluidVariantStorage != null) {
                    try(Transaction transaction = Transaction.openOuter()) {
                        if(fluidVariantStorage.supportsExtraction()) {
                            ResourceAmount<FluidVariant> fluidVariantResource = StorageUtil.findExtractableContent(fluidVariantStorage, transaction);
                            if(fluidVariantResource != null && fluidVariantResource.amount() > 0 && !fluidVariantResource.resource().isBlank()) {
                                long amountInserted = tank.insert(fluidVariantResource.resource(), Math.min(fluidVariantResource.amount(), FluidConstants.BUCKET), transaction);
                                long amountExtracted = fluidVariantStorage.extract(fluidVariantResource.resource(), Math.min(fluidVariantResource.amount(), FluidConstants.BUCKET), transaction);
                                if(amountExtracted == amountInserted) {
                                    level.method_8396(player, pos, FluidTypeHelper.getSound(fluidVariantResource.resource(), FluidTypeHelper.BUCKET_FILL), class_3419.field_15245, 1.0F, 1.0F);
                                    transaction.commit();
                                    triggerAdvancement(player, ActionTypeTrigger.HOSE_SUCK);
                                    return class_1269.field_5812;
                                }
                            }
                        }
                    }
                }
                //Pick fluid from block
                class_3965 result = method_7872(level, player, class_3959.class_242.field_1345);
                class_2338 blockpos = result.method_17777();
                class_2350 direction1 = result.method_17780();
                class_2338 blockpos1 = blockpos.method_10093(direction);

                if(level.method_8505(player, blockpos) && player.method_7343(blockpos1, direction1, stack)) {
                    class_2680 blockstate1 = level.method_8320(blockpos);
                    if(blockstate1.method_26204() instanceof class_2263 pickup) {
                        class_3611 fluid = blockstate1.method_26227().method_15772();
                        if(fluid != class_3612.field_15906) {
                            FluidVariantWrapper fluidStack = new FluidVariantWrapper(FluidVariant.of(fluid), FluidConstants.BUCKET);
                            long tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                            boolean canFill = tank.isEmpty() || FluidUtil.isSameVariant(tank.getFluid().fluidVariant(), fluidStack.fluidVariant());
                            if(canFill && (fluidStack.getAmount() + tankAmount <= tank.getCapacity())) {
                                class_1799 actualFluid = pickup.method_9700(player, level, blockpos, blockstate1);
                                if(!actualFluid.method_7960()) {
                                    level.method_8396(player, result.method_17777(), FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_FILL) == null ? (fluid.method_15791(class_3486.field_15518) ? class_3417.field_15202 : class_3417.field_15126) : FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_FILL), class_3419.field_15245, 1.0F, 1.0F);
                                    tank.fill(new FluidVariantWrapper(FluidVariant.of(fluid), FluidConstants.BUCKET), false);
                                    triggerAdvancement(player, ActionTypeTrigger.HOSE_SUCK);
                                    return class_1269.field_5812;
                                }
                            }
                        }
                    }
                }
            }
            if(getHoseMode(stack) == SPILL_MODE) {
                //Transfer fluid to fluid handler
                if(fluidVariantStorage != null && !tank.isEmpty()) {
                    FluidVariantWrapper fluidStack = tank.getFluid();
                    try(Transaction transaction = Transaction.openOuter()) {
                        long amountExtracted = tank.extract(fluidStack.fluidVariant(), Math.min(fluidStack.amount(), FluidConstants.BUCKET), transaction);
                        long amountInserted = fluidVariantStorage.insert(fluidStack.fluidVariant(), Math.min(fluidStack.amount(), FluidConstants.BUCKET), transaction);
                        if(amountExtracted > 0 && amountExtracted == amountInserted) {
                            level.method_8396(player, pos, FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_FILL), class_3419.field_15245, 1.0F, 1.0F);
                            transaction.commit();
                            triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL);
                            return class_1269.field_5812;
                        }
                    }
                }

                //Try to splash potion in the world
                if(tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL) {
                    if(tank.getFluid().fluidVariant().getComponentMap().method_57830(class_9334.field_49628, class_9279.field_49302).method_57450("PotionType")) {
                        int potionType = tank.getFluid().fluidVariant().getComponentMap().method_57829(class_9334.field_49628).method_57461().method_10550("PotionType");
                        if(potionType == 1) {
                            if(tank.getFluidAmount() >= FluidConstants.BOTTLE) {
                                class_1799 potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid().fluidVariant());
                                long drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                                tank.drain(drainAmount, false);
                                triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL_POTION);
                                return class_1269.field_5812;
                            }
                        } else if(potionType == 2) {
                            if(tank.getFluidAmount() >= FluidConstants.BOTTLE) {
                                class_1799 potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid().fluidVariant());
                                long drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                                tank.drain(drainAmount, false);
                                triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL_POTION);
                                return class_1269.field_5812;
                            }
                        }
                    }
                }

                //Try to put fluid in the world
                if(!tank.isEmpty()) {
                    class_2680 blockState = level.method_8320(pos);
                    class_2248 block = blockState.method_26204();
                    class_3611 fluid = tank.getFluid().fluidVariant().getFluid();
                    if(tank.getFluidAmount() >= FluidConstants.BUCKET && fluid instanceof class_3609 flowingFluid) {
                        if(block instanceof class_2402 container && container.method_10310(player, level, pos, blockState, fluid)) {
                            container.method_10311(level, pos, blockState, flowingFluid.method_15729(false));
                            level.method_8396(player, pos, FluidTypeHelper.getSound(tank.getFluid().fluidVariant(), FluidTypeHelper.BUCKET_EMPTY), class_3419.field_15245, 1.0F, 1.0F);
                            tank.drain(FluidConstants.BUCKET, false);
                            triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL);
                            return class_1269.field_5812;
                        }
                    }
                    int x = pos.method_10263();
                    int y = pos.method_10264();
                    int z = pos.method_10260();
                    if(!level.method_8320(pos).method_26188(fluid)) {
                        switch(context.method_8038()) {
                            case field_11039:
                                --x;
                                break;
                            case field_11034:
                                ++x;
                                break;
                            case field_11043:
                                --z;
                                break;
                            case field_11035:
                                ++z;
                                break;
                            case field_11036:
                                ++y;
                                break;
                            case field_11033:
                                --y;
                                break;
                            default:
                                break;
                        }
                    }

                    class_2338 newPos = new class_2338(x, y, z);
                    FluidVariantWrapper fluidStack = tank.getFluid();
                    if(level.method_8320(newPos).method_26188(fluid)) {
                        boolean flag = !level.method_8320(newPos).method_51367();
                        if(level.method_8597().comp_644() && fluidStack.fluidVariant().getFluid().method_15791(class_3486.field_15517)) {
                            tank.drain(FluidConstants.BUCKET, false);
                            level.method_8396(null, newPos, class_3417.field_15102, class_3419.field_15245, 0.5F, 2.6F + (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.8F);
                            for(int i = 0; i < 3; ++i) {
                                double d0 = newPos.method_10263() + level.method_8409().method_43058();
                                double d1 = newPos.method_10264() + level.method_8409().method_43058() * 0.5D + 0.5D;
                                double d2 = newPos.method_10260() + level.method_8409().method_43058();
                                level.method_8406(class_2398.field_11237, d0, d1, d2, 0.0D, 0.0D, 0.0D);
                            }
                            triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL);
                            return class_1269.field_5812;
                        }
                        if(fluidStack.getAmount() >= FluidConstants.BUCKET) {
                            if(!level.field_9236 && flag && !level.method_8320(newPos).method_51176()) {
                                level.method_22352(newPos, false);
                            }

                            if(level.method_8652(newPos, fluidStack.fluidVariant().getFluid().method_15785().method_15759(), 3)) {
                                level.method_8396(player, newPos, FluidTypeHelper.getSound(fluidStack.fluidVariant(), FluidTypeHelper.BUCKET_EMPTY), class_3419.field_15245, 1.0F, 1.0F);
                                tank.drain(FluidConstants.BUCKET, false);
                                level.method_8452(newPos, fluidStack.fluidVariant().getFluid().method_15785().method_15759().method_26204());
                            }
                            triggerAdvancement(player, ActionTypeTrigger.HOSE_SPILL);
                            return class_1269.field_5812;
                        }
                    }
                }
            }
            if(getHoseMode(stack) == DRINK_MODE) {
                if(!tank.isEmpty()) {
                    if(EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, player)) {
                        player.method_6019(context.method_20287());
                        return class_1269.field_5812;
                    }
                }
            }
        }
        return class_1269.field_5814;
    }

    public void triggerAdvancement(class_1657 player, String type) {
        if(player instanceof class_3222 serverPlayer) {
            ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, type);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entityLiving) {
        if(entityLiving instanceof class_1657 player) {
            if(ComponentUtils.isWearingBackpack(player)) {
                BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY);
                if(!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                    return stack;
                }
                FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
                if(getHoseMode(stack) == DRINK_MODE) {
                    if(tank != null) {
                        if(ServerActions.setFluidEffect(level, player, tank)) {
                            long drainAmount = EffectFluidRegistry.getHighestFluidEffectAmount(tank.getFluid().fluidVariant().getFluid());
                            if(tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL) {
                                triggerAdvancement(player, ActionTypeTrigger.HOSE_DRINK_POTION);
                            }
                            triggerAdvancement(player, ActionTypeTrigger.HOSE_DRINK);
                            tank.drain(drainAmount, false);
                        }
                    }
                }
            }
        }
        return stack;
    }

/*    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if(ComponentUtils.isWearingBackpack(player) && hand == InteractionHand.MAIN_HAND && getHoseMode(stack) == SUCK_MODE) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player);
            if(!wrapper.getUpgradeManager().tanksUpgrade.isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().tanksUpgrade.get());
            Fluid milk = ModFluids.MILK_STILL;
            if(milk != null) {
                if(entity instanceof Cow) {
                    long tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                    FluidVariantWrapper milkStack = new FluidVariantWrapper(FluidVariant.of(milk), FluidConstants.BUCKET);
                    if(milkStack.fluidVariant().getFluid() != Fluids.EMPTY) {
                        if((tank.isEmpty() || FluidUtil.isSameVariant(tank.getFluid().fluidVariant(), milkStack.fluidVariant())) && milkStack.getAmount() + tankAmount <= tank.getCapacity()) {
                            tank.fill(milkStack, false);
                            player.playSound(SoundEvents.COW_MILK, 1.0F, 1.0F);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
        }
        return InteractionResult.PASS;
    } */

    public static final int NO_ASSIGN = 0;
    public static final int SUCK_MODE = 1;
    public static final int SPILL_MODE = 2;
    public static final int DRINK_MODE = 3;

    public static int getHoseMode(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.HOSE_MODES)) {
            //1 = Suck mode
            //2 = Spill mode
            //3 = Drink mode
            return stack.method_57824(ModDataComponents.HOSE_MODES).get(0);
        }
        return NO_ASSIGN;
    }

    public static int getHoseTank(class_1799 stack) {
        //Weird check to avoid unknown crash
        if(stack.method_57825(ModDataComponents.HOSE_MODES, List.of()).size() == 2) {
            //1 = Left tank
            //2 = Right tank
            return stack.method_57824(ModDataComponents.HOSE_MODES).get(1);
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(class_1799 stack, TanksUpgrade upgrade) {
        return getHoseTank(stack) == 1 ? upgrade.getLeftTank() : upgrade.getRightTank();
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if(stack.method_57826(ModDataComponents.HOSE_MODES)) {
            int mode = stack.method_57824(ModDataComponents.HOSE_MODES).get(0);
            if(mode == SUCK_MODE) {
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.hose.suck").method_27692(class_124.field_1078));
            }
            if(mode == SPILL_MODE) {
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.hose.spill").method_27692(class_124.field_1078));
            }
            if(mode == DRINK_MODE) {
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.hose.drink").method_27692(class_124.field_1078));
            }
            int tank = stack.method_57824(ModDataComponents.HOSE_MODES).get(1);
            if(tank == 1) {
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.hose.tank_left").method_27692(class_124.field_1078));
            }
            if(tank == 2) {
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.hose.tank_right").method_27692(class_124.field_1078));
            }
        }
    }
}