package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import org.apache.commons.lang3.function.TriFunction;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class JukeboxUpgradeItem extends UpgradeItem {
    public JukeboxUpgradeItem(class_1793 pProperties) {
        super(pProperties, "jukebox_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.enableJukeboxUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return JukeboxUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents musicDisk = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(1));
            return Optional.of(new JukeboxUpgrade(upgradeManager, dataHolderSlot, musicDisk.getItems()));
        };
    }
}