package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import org.apache.commons.lang3.function.TriFunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class PickupUpgradeItem extends UpgradeItem {
    public PickupUpgradeItem(class_1793 pProperties) {
        super(pProperties, "pickup_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.enableUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return AutoPickupUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            List<String> filterTags = new ArrayList<>(provider.method_57825(ModDataComponents.FILTER_TAGS, new ArrayList<>()));
            return Optional.of(new AutoPickupUpgrade(upgradeManager, dataHolderSlot, filter.getItems(), filterTags));
        };
    }
}