package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.SmokerUpgrade;
import org.apache.commons.lang3.function.TriFunction;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class SmokerUpgradeItem extends UpgradeItem {
    public SmokerUpgradeItem(class_1793 pProperties) {
        super(pProperties, "smoker_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.enableSmokerUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return SmokerUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents contents = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(3));
            return Optional.of(new SmokerUpgrade(upgradeManager, dataHolderSlot, contents.getItems()));
        };
    }
}