package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import org.apache.commons.lang3.function.TriFunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class VoidUpgradeItem extends UpgradeItem {
    public VoidUpgradeItem(class_1793 pProperties) {
        super(pProperties, "void_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.enableUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public boolean requiresEquippedBackpack() {
        return false;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return VoidUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            BackpackContainerContents newFilter = BackpackContainerContents.updateSlot(filter, new BackpackContainerContents.Slot(0, class_1799.field_8037.method_7972())); //#TODO TO REMOVE IN THE FUTURE, KEEP IT NOW TO PREVENT DUPLICATION WHILE UPDATING FROM PREV VERSION
            List<String> filterTags = new ArrayList<>(provider.method_57825(ModDataComponents.FILTER_TAGS, new ArrayList<>()));
            return Optional.of(new VoidUpgrade(upgradeManager, dataHolderSlot, newFilter.getItems(), filterTags));
        };
    }
}