package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_1309.class, priority = 0)
public class LivingEntityPriorityMixin {
    @Inject(method = "dropAllDeathLoot", at = @At("HEAD"))
    private void drop(class_3218 level, class_1282 damageSource, CallbackInfo ci) {
        class_1309 e = (class_1309)(Object)this;
        if(!(e instanceof class_3222 player)) return;

        //Mixin responsible only for creating backup of equipped backpack before any compatibility actions are taken, does not make any changes to backpacks or anything
        if(ComponentUtils.isWearingBackpack(player)) {
            BackpackManager.addBackpack(player, ComponentUtils.getWearingBackpack(player));
        }
    }
}
