package com.tiviacz.travelersbackpack.mixin.abilities;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1303.class)
public class ExperienceOrbEntityMixin {
    @Shadow
    private int value;

    @Inject(method = "playerTouch", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;take(Lnet/minecraft/world/entity/Entity;I)V", shift = At.Shift.AFTER))
    public void onPlayerCollision(class_1657 player, CallbackInfo ci) {
        if(TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities) {
            this.value *= BackpackAbilities.ABILITIES.lapisAbility(player);
        }
    }
}