package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.item.HoseItem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import java.util.List;

public record ClientboundSyncItemStackPacket(int entityId, int slot, class_1799 itemStackInstance,
                                             class_9323 map) implements class_8710 {
    public static final class_2960 ID = class_2960.method_60655(TravelersBackpack.MODID, "sync_itemstack");
    public static final class_9154<ClientboundSyncItemStackPacket> TYPE = new class_9154<>(ID);
    public static final class_9139<class_9129, ClientboundSyncItemStackPacket> STREAM_CODEC = class_9139.method_56905(
            class_9135.field_49675, ClientboundSyncItemStackPacket::entityId,
            class_9135.field_49675, ClientboundSyncItemStackPacket::slot,
            class_9135.method_56368(class_1799.field_49267), ClientboundSyncItemStackPacket::itemStackInstance,
            class_9135.method_56896(class_9323.field_50234), ClientboundSyncItemStackPacket::map,
            ClientboundSyncItemStackPacket::new
    );

    public static void handle(final ClientboundSyncItemStackPacket message, ClientPlayNetworking.Context ctx) {
        ctx.client().execute(() -> {
            class_1657 player = (class_1657)class_310.method_1551().field_1724.method_37908().method_8469(message.entityId());

            //Sync clientside wrapper if integration enabled (Wrapper created on the fly)
            if(player != null && message.slot() == -1) {
                if(player.field_7512 instanceof BackpackBaseMenu menu) {
                    class_1799 oldStack = menu.getWrapper().getBackpackStack().method_7972();
                    oldStack.method_57365(message.map());
                    menu.getWrapper().setBackpackStack(oldStack);
                    return;
                }
                return;
            }

            if(player != null && player.method_31548().field_7547.get(message.slot()).method_31574(message.itemStackInstance().method_7909())) {
                class_1799 oldStack = player.method_31548().field_7547.get(message.slot()).method_7972();
                //Sync component changes on client
                player.method_31548().field_7547.get(message.slot()).method_57365(message.map());
                class_1799 newStack = player.method_31548().field_7547.get(message.slot()).method_7972();

                //Update Item Backpack
                if(player.field_7512 instanceof BackpackBaseMenu menu) {
                    menu.getWrapper().setBackpackStack(player.method_31548().field_7547.get(message.slot()));
                }

                //Display hose mode if changed
                if(message.map().method_57832(ModDataComponents.HOSE_MODES)) {
                    int changedMode = getChangedMode(oldStack, newStack);
                    if(changedMode != -1) {
                        player.method_7353(getNextModeMessage(changedMode, message.map().method_57829(ModDataComponents.HOSE_MODES).get(changedMode)), true);
                    }
                }
            }
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }


    public static int getChangedMode(class_1799 oldStack, class_1799 newStack) {
        if(oldStack.method_57825(ModDataComponents.HOSE_MODES, List.of(0, 0)).get(0) != newStack.method_57825(ModDataComponents.HOSE_MODES, List.of(0, 0)).get(0)) {
            return 0;
        }
        if(oldStack.method_57825(ModDataComponents.HOSE_MODES, List.of(0, 0)).get(1) != newStack.method_57825(ModDataComponents.HOSE_MODES, List.of(0, 0)).get(1)) {
            return 1;
        }
        return -1;
    }

    public static class_2561 getNextModeMessage(int changedMode, int data) {
        if(changedMode == 0) {
            if(data == HoseItem.SPILL_MODE) {
                return class_2561.method_43471("item.travelersbackpack.hose.spill");
            } else if(data == HoseItem.DRINK_MODE) {
                return class_2561.method_43471("item.travelersbackpack.hose.drink");
            }
            return class_2561.method_43471("item.travelersbackpack.hose.suck");
        } else {
            if(data == 1) {
                return class_2561.method_43471("item.travelersbackpack.hose.tank_left");
            } else {
                return class_2561.method_43471("item.travelersbackpack.hose.tank_right");
            }
        }
    }
}