package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public record ClientboundUpdateConfigPacket(class_2487 compound) implements class_8710 {
    public static final class_8710.class_9154<ClientboundUpdateConfigPacket> TYPE = new class_8710.class_9154<>(class_2960.method_60655(TravelersBackpack.MODID, "update_config"));
    public static final class_9139<class_9129, ClientboundUpdateConfigPacket> STREAM_CODEC = class_9139.method_56434(class_9135.field_48556, ClientboundUpdateConfigPacket::compound, ClientboundUpdateConfigPacket::new);

    public static void handle(ClientboundUpdateConfigPacket message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            TravelersBackpack.LOGGER.info("Syncing config from server to client...");
            TravelersBackpackConfigData configData = TravelersBackpackConfig.readFromNbt(message.compound());
            AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).setConfig(configData);

            //Abilities
            BackpackAbilities.ALLOWED_ABILITIES.clear();
            TravelersBackpackConfig.loadItemsFromConfig(TravelersBackpackConfig.getConfig().backpackAbilities.allowedAbilities, com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES);

            //Load Backpack Effects
            BackpackAbilities.getBackpackEffects().clear();
            TravelersBackpackConfig.loadBackpackEffectsFromConfig(configData.backpackAbilities.backpackEffects, com.tiviacz.travelersbackpack.common.BackpackAbilities.BACKPACK_EFFECTS);

            //Update allowed abilities if added effect
            com.tiviacz.travelersbackpack.common.BackpackAbilities.getBackpackEffects().entries().stream().forEach(entry -> {
                if(!com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES.contains(entry.getKey())) {
                    com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES.add(entry.getKey());
                }
                if(!com.tiviacz.travelersbackpack.common.BackpackAbilities.ITEM_ABILITIES_LIST.contains(entry.getKey())) {
                    com.tiviacz.travelersbackpack.common.BackpackAbilities.ITEM_ABILITIES_LIST.add(entry.getKey());
                }
            });

            //Remove all abilities that are not allowed //#TODO probably tweak
            List<class_1792> allowed = new ArrayList<>(BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.ITEM_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));

            //Cooldowns
            BackpackAbilities.getCooldowns().clear();
            TravelersBackpackConfig.loadCooldownsFromConfig(configData.backpackAbilities.cooldowns, com.tiviacz.travelersbackpack.common.BackpackAbilities.COOLDOWNS);
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
