package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankActions;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ServerboundActionTagPacket(class_2487 actionTag) implements class_8710 {
    public static final class_9154<ServerboundActionTagPacket> TYPE = new class_9154<>(class_2960.method_60655(TravelersBackpack.MODID, "action_tag"));
    public static final class_9139<class_9129, ServerboundActionTagPacket> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48556, ServerboundActionTagPacket::actionTag,
            ServerboundActionTagPacket::new
    );

    public static final int UPGRADE_TAB = 0;
    public static final int OPEN_SCREEN = 1;
    public static final int OPEN_BACKPACK = 2;
    public static final int SORTER = 3;
    public static final int SLEEPING_BAG = 4;
    public static final int FILL_TANK = 5;
    public static final int SWAP_TOOL = 6;
    public static final int TOGGLE_BUTTONS_VISIBILITY = 7;
    public static final int SHOW_TOOL_SLOTS = 8;
    public static final int REMOVE_UPGRADE = 9;
    public static final int OPEN_SETTINGS = 10;
    public static final int SWITCH_HOSE_MODE = 11;
    public static final int SWITCH_HOSE_TANK = 12;
    public static final int TOGGLE_VISIBILITY = 13;
    public static final int ABILITY_SLIDER = 14;
    public static final int EQUIP_BACKPACK = 15;

    public static void handle(ServerboundActionTagPacket message, ServerPlayNetworking.Context ctx) {
        ctx.player().method_5682().execute(() -> {
            class_3222 player = ctx.player();
            class_2487 actionTag = message.actionTag();
            int actionType = actionTag.method_10550("ActionType");
            switch(actionType) {
                case UPGRADE_TAB -> {
                    int slot = actionTag.method_10550("Arg0");
                    boolean open = actionTag.method_10577("Arg1");
                    int packetType = actionTag.method_10550("Arg2");
                    ServerActions.modifyUpgradeTab(player, slot, open, packetType);
                }
                case OPEN_SCREEN -> {
                    if(ComponentUtils.isWearingBackpack(player)) {
                        BackpackContainer.openBackpack(player, ComponentUtils.getWearingBackpack(player), Reference.WEARABLE_SCREEN_ID);
                    }
                }
                case OPEN_BACKPACK -> {
                    int index = actionTag.method_10550("Arg0");
                    boolean fromSlot = actionTag.method_10577("Arg1");
                    ServerActions.openBackpackFromSlot(player, index, fromSlot);
                }
                case SORTER -> {
                    int button = actionTag.method_10550("Arg0");
                    boolean shiftPressed = actionTag.method_10577("Arg1");
                    ServerActions.sortBackpack(player, button, shiftPressed);
                }
                case SLEEPING_BAG -> {
                    class_2338 pos = class_2338.field_25064.parse(class_2509.field_11560, actionTag.method_10580("Arg0")).getOrThrow();
                    boolean isEquipped = actionTag.method_10577("Arg1");
                    ServerActions.toggleSleepingBag(player, pos, isEquipped);
                }
                case FILL_TANK -> {
                    boolean leftTank = actionTag.method_10577("Arg0");
                    TankActions.fillTank(player, leftTank);
                }
                case SWAP_TOOL -> {
                    double scrollDelta = actionTag.method_10574("Arg0");
                    ServerActions.swapTool(player, scrollDelta);
                }
                case TOGGLE_BUTTONS_VISIBILITY -> ServerActions.toggleButtonsVisibility(player);
                case SHOW_TOOL_SLOTS -> {
                    boolean show = actionTag.method_10577("Arg0");
                    ServerActions.showToolSlots(player, show);
                }
                case REMOVE_UPGRADE -> {
                    int slot = actionTag.method_10550("Arg0");
                    ServerActions.removeBackpackUpgrade(player, slot);
                }
                case OPEN_SETTINGS -> {
                    int entityId = actionTag.method_10550("Arg0");
                    boolean open = actionTag.method_10577("Arg1");
                    ServerActions.openBackpackSettings(player, entityId, open);
                }
                case SWITCH_HOSE_MODE -> {
                    double scrollDelta = actionTag.method_10574("Arg0");
                    ServerActions.switchHoseMode(player, scrollDelta);
                }
                case SWITCH_HOSE_TANK -> ServerActions.toggleHoseTank(player);
                case TOGGLE_VISIBILITY -> ServerActions.toggleVisibility(player);
                case ABILITY_SLIDER -> {
                    boolean sliderValue = actionTag.method_10577("Arg0");
                    ServerActions.switchAbilitySlider(player, sliderValue);
                }
                case EQUIP_BACKPACK -> {
                    boolean equip = actionTag.method_10577("Arg0");
                    ServerActions.equipBackpack(player, equip);
                }
            }
        });
    }

    public static void create(int type, Object... args) {
        PacketDistributor.sendToServer(new ServerboundActionTagPacket(createPacketTag(type, args)));
    }

    public static class_2487 createPacketTag(int type, Object... args) {
        class_2487 tag = new class_2487();
        tag.method_10569("ActionType", type);
        for(int i = 0; i < args.length; i++) {
            String argName = "Arg" + i;
            if(args[i] instanceof class_2338) {
                tag.method_10566(argName, class_2338.field_25064.encodeStart(class_2509.field_11560, (class_2338)args[i]).getOrThrow());
            } else if(args[i] instanceof Boolean) {
                tag.method_10556(argName, (boolean)args[i]);
            } else if(args[i] instanceof Byte) {
                tag.method_10567(argName, (byte)args[i]);
            } else if(args[i] instanceof Integer) {
                tag.method_10569(argName, (int)args[i]);
            } else if(args[i] instanceof Double) {
                tag.method_10549(argName, (double)args[i]);
            }
        }
        return tag;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
