package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;

public record ServerboundFilterSettingsPacket(int slot, List<Integer> settings) implements class_8710 {
    public static final class_9154<ServerboundFilterSettingsPacket> TYPE = new class_9154<>(class_2960.method_60655(TravelersBackpack.MODID, "filter_settings"));

    public static final class_9139<class_9129, ServerboundFilterSettingsPacket> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675, ServerboundFilterSettingsPacket::slot,
            class_9135.field_49675.method_56433(class_9135.method_56363()), ServerboundFilterSettingsPacket::settings,
            ServerboundFilterSettingsPacket::new
    );

    public static void handle(final ServerboundFilterSettingsPacket message, ServerPlayNetworking.Context ctx) {
        ctx.player().method_5682().execute(() -> {

            class_1657 player = ctx.player();

            if(player instanceof class_3222 serverPlayer && serverPlayer.field_7512 instanceof BackpackBaseMenu menu) {
                BackpackWrapper wrapper = menu.getWrapper();
                if(!wrapper.getUpgrades().getStackInSlot(message.slot()).method_7960()) {

                    class_1799 upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot()).method_7972();
                    upgradeStack.method_57379(ModDataComponents.FILTER_SETTINGS, message.settings());
                    wrapper.getUpgrades().setStackInSlot(message.slot(), upgradeStack);

                    if(wrapper.getUpgradeManager().mappedUpgrades.get(message.slot()).isPresent()) {
                        if(wrapper.getUpgradeManager().mappedUpgrades.get(message.slot()).get() instanceof IFilter filter) {
                            filter.updateSettings();
                        }
                    }
                    menu.getWrapper().saveHandler.run();
                }
            }
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
