package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public record ServerboundSlotPacket(int selectType, List<Integer> unsortables,
                                    List<Pair<Integer, Boolean>> memorizedSlots) implements class_8710 {
    public static final class_9154<ServerboundSlotPacket> TYPE = new class_9154<>(class_2960.method_60655(TravelersBackpack.MODID, "slots"));
    public static final class_9139<class_2540, ServerboundSlotPacket> STREAM_CODEC = class_9139.method_56436(
            class_9135.field_49675, ServerboundSlotPacket::selectType,
            class_9135.field_49675.method_56433(class_9135.method_56363()), ServerboundSlotPacket::unsortables,
            class_9135.method_56368(Codec.mapPair(Codec.INT.fieldOf("index"), Codec.BOOL.fieldOf("matchComponents")).codec()).method_56433(class_9135.method_56363()), ServerboundSlotPacket::memorizedSlots,
            ServerboundSlotPacket::new
    );

    public static final int UNSORTABLES = 0;
    public static final int MEMORY = 1;

    public static void handle(final ServerboundSlotPacket message, ServerPlayNetworking.Context ctx) {
        ctx.player().method_5682().execute(() -> {
            class_1657 player = ctx.player();
            if(player instanceof class_3222 serverPlayer && serverPlayer.field_7512 instanceof BackpackSettingsMenu menu) {
                if(message.selectType() == UNSORTABLES) {
                    menu.getWrapper().setUnsortableSlots(message.unsortables());
                }
                if(message.selectType() == MEMORY) {
                    List<Pair<Integer, Pair<class_1799, Boolean>>> oldMemoryStacks = menu.getWrapper().getMemorySlots();
                    List<Pair<Integer, Pair<class_1799, Boolean>>> memoryStacks = new ArrayList<>();
                    for(Pair<Integer, Boolean> memorizedSlot : message.memorizedSlots()) {
                        class_1799 retrievedStack = memorizedSlot.getSecond() ? menu.method_7611(memorizedSlot.getFirst()).method_7677() : menu.method_7611(memorizedSlot.getFirst()).method_7677().method_7909().method_7854();
                        if(retrievedStack.method_7960()) {
                            for(Pair<Integer, Pair<class_1799, Boolean>> oldMemorizedSlot : oldMemoryStacks) {
                                if(oldMemorizedSlot.getFirst().equals(memorizedSlot.getFirst())) {
                                    retrievedStack = oldMemorizedSlot.getSecond().getFirst();
                                    break;
                                }
                            }
                        }
                        if(retrievedStack.method_7960()) {
                            continue; //not allowed in codec
                        }
                        memoryStacks.add(Pair.of(memorizedSlot.getFirst(), Pair.of(retrievedStack, memorizedSlot.getSecond())));
                    }
                    menu.getWrapper().setMemorySlots(memoryStacks);
                }

                //Update backpack data on clients
                menu.getWrapper().sendDataToClients(ModDataComponents.SLOTS);
            }
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
