package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public class InventoryHelper {
    public static class_1799 removeItem(ItemStackHandler handler, int slot, int amount) {
        if(slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).method_7960() && amount > 0) {
            class_1799 currentStack = handler.getStackInSlot(slot).method_7972();
            class_1799 stackAtPointer = currentStack.method_7972();
            currentStack.method_7971(amount);
            handler.setStackInSlot(slot, currentStack);
            return stackAtPointer;
        }
        return class_1799.field_8037;
    }

    public static class_1799 removeItemShiftClick(ItemStackHandler handler, int slot, int amount) {
        if(slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).method_7960() && amount > 0) {
            class_1799 currentStack = handler.getStackInSlot(slot);
            currentStack.method_7971(amount);
            handler.setStackInSlot(slot, currentStack);
            return handler.getStackInSlot(slot);
        }
        return class_1799.field_8037;
    }

    public static class_1799 takeItem(ItemStackHandler handler, int slot) {
        return slot >= 0 && slot < handler.getSlots() ? handler.insertItem(slot, class_1799.field_8037, false) : class_1799.field_8037;
    }

    public static boolean isEmpty(ItemStackHandler handler) {
        for(int i = 0; i < handler.getSlots(); i++) {
            if(!handler.getStackInSlot(i).method_7960()) {
                return false;
            }
        }
        return true;
    }

    public static BackpackContainerContents itemsToList(int size, ItemStackHandler handler) {
        List<class_1799> list = new ArrayList<>(size);

        for(int i = 0; i < handler.getSlots(); i++) {
            list.add(handler.getStackInSlot(i));
        }
        for(int i = handler.getSlots(); i < size; i++) {
            list.add(class_1799.field_8037);
        }
        return BackpackContainerContents.fromItems(size, list);
    }

    public static void iteratePlayerInv(class_1661 playerInv, BiConsumer<Integer, class_1799> consumer) {
        for(int i = 0; i < playerInv.method_5439(); i++) {
            class_1799 stack = playerInv.method_5438(i);
            consumer.accept(i, stack);
        }
    }

    public static void iterateHandler(ItemStackHandler handler, BiConsumer<Integer, class_1799> consumer) {
        for(int i = 0; i < handler.getSlots(); i++) {
            class_1799 stack = handler.getStackInSlot(i);
            consumer.accept(i, stack);
        }
    }

    public static boolean iterate(ItemStackHandler handler, BiFunction<Integer, class_1799, Boolean> function) {
        for(int i = 0; i < handler.getSlots(); i++) {
            boolean matches = function.apply(i, handler.getStackInSlot(i).method_7972());
            if(matches) {
                return true;
            }
        }
        return false;
    }

    public static class_1799 addItemStackToHandler(ItemStackHandler handler, class_1799 stack, boolean simulate) {
        return insertItemStacked(handler, stack, simulate);
    }

    public static class_1799 extractFromBackpack(ItemStackHandler handler, class_1799 stack, int amount, boolean simulate) {
        for(int i = 0; i < handler.getSlots(); i++) {
            if(class_1799.method_31577(stack, handler.getStackInSlot(i))) {
                return handler.extractItem(i, amount, simulate);
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 insertItemStacked(ItemStackHandler inventory, class_1799 stack, boolean simulate) {
        if(inventory == null || stack.method_7960())
            return stack;

        // not stackable -> just insert into a new slot
        if(!stack.method_7946()) {
            return insertItem(inventory, stack, simulate);
        }

        int sizeInventory = inventory.getSlots();

        // go through the inventory and try to fill up already existing items
        for(int i = 0; i < sizeInventory; i++) {
            class_1799 slot = inventory.getStackInSlot(i);
            if(class_1799.method_31577(slot, stack)) {
                stack = inventory.insertItem(i, stack, simulate);

                if(stack.method_7960()) {
                    break;
                }
            }
        }

        // insert remainder into empty slots
        if(!stack.method_7960()) {
            // find empty slot
            for(int i = 0; i < sizeInventory; i++) {
                if(inventory.getStackInSlot(i).method_7960()) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if(stack.method_7960()) {
                        break;
                    }
                }
            }
        }

        return stack;
    }

    public static class_1799 insertItem(ItemStackHandler dest, class_1799 stack, boolean simulate) {
        if(dest == null || stack.method_7960())
            return stack;

        for(int i = 0; i < dest.getSlots(); i++) {
            stack = dest.insertItem(i, stack, simulate);
            if(stack.method_7960()) {
                return class_1799.field_8037;
            }
        }

        return stack;
    }
}